/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.capability;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import lazy.baubles.api.bauble.IBauble;
import lazy.baubles.api.bauble.IBaublesItemHandler;
import lazy.baubles.api.cap.CapabilityBaubles;
import lazy.baubles.event.EventHandlerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class BaublesContainer
extends ItemStackHandler
implements IBaublesItemHandler {
    private static final int BAUBLE_SLOTS = 7;
    private final ItemStack[] previous = new ItemStack[7];
    private final boolean[] changed = new boolean[7];
    private boolean blockEvents = false;
    private final LivingEntity holder;

    public BaublesContainer(LivingEntity player) {
        super(7);
        this.holder = player;
        Arrays.fill(this.previous, ItemStack.f_41583_);
    }

    public void setSize(int size) {
        if (size != 7) {
            System.out.println("Cannot resize baubles container");
        }
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        LazyOptional baubleCap = stack.getCapability(CapabilityBaubles.ITEM_BAUBLE);
        if (stack.m_41619_() || !baubleCap.isPresent()) {
            return false;
        }
        IBauble bauble = (IBauble)baubleCap.orElseThrow(NullPointerException::new);
        return bauble.canEquip(this.holder) && bauble.getBaubleType(stack).hasSlot(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (stack.m_41619_() || this.isItemValidForSlot(slot, stack)) {
            super.setStackInSlot(slot, stack);
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.isItemValidForSlot(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    public boolean isEventBlocked() {
        return this.blockEvents;
    }

    @Override
    public void setEventBlock(boolean blockEvents) {
        this.blockEvents = blockEvents;
    }

    protected void onContentsChanged(int slot) {
        this.changed[slot] = true;
    }

    @Override
    public void tick() {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            stack.getCapability(CapabilityBaubles.ITEM_BAUBLE).ifPresent(b -> b.onWornTick(this.holder, stack));
        }
        this.sync();
    }

    private void sync() {
        if (!(this.holder instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer holder = (ServerPlayer)this.holder;
        ArrayList<ServerPlayer> receivers = null;
        for (byte i = 0; i < this.getSlots(); i = (byte)((byte)(i + 1))) {
            ItemStack stack = this.getStackInSlot(i);
            boolean autoSync = stack.getCapability(CapabilityBaubles.ITEM_BAUBLE).map(b -> b.willAutoSync(this.holder)).orElse(false);
            if (!this.changed[i] && (!autoSync || ItemStack.m_41746_((ItemStack)stack, (ItemStack)this.previous[i]))) continue;
            if (receivers == null) {
                receivers = new ArrayList<ServerPlayer>(((ServerLevel)this.holder.f_19853_).m_8795_(serverPlayerEntity -> true));
                receivers.add(holder);
            }
            EventHandlerEntity.syncSlot((Player)holder, i, stack, receivers);
            this.changed[i] = false;
            this.previous[i] = stack.m_41777_();
        }
    }
}

