/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.api.bauble;

import java.util.Arrays;

public enum BaubleType {
    AMULET(0),
    RING(1, 2),
    BELT(3),
    TRINKET(0, 1, 2, 3, 4, 5, 6),
    HEAD(4),
    BODY(5),
    CHARM(6);

    int[] validSlots;

    private BaubleType(int ... validSlots) {
        this.validSlots = validSlots;
    }

    public boolean hasSlot(int slot) {
        return Arrays.stream(this.validSlots).anyMatch(s -> s == slot);
    }

    public int[] getValidSlots() {
        return this.validSlots;
    }

    public static BaubleType getFromString(String type) {
        return switch (type) {
            case "ring" -> RING;
            case "amulet" -> AMULET;
            case "belt" -> BELT;
            case "head" -> HEAD;
            case "body" -> BODY;
            case "charm" -> CHARM;
            default -> TRINKET;
        };
    }
}

