/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.api;

import lazy.baubles.api.bauble.BaubleType;
import lazy.baubles.api.bauble.IBaublesItemHandler;
import lazy.baubles.api.cap.CapabilityBaubles;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.LazyOptional;

public class BaublesAPI {
    public static final String MOD_ID = "baubles";

    public static LazyOptional<IBaublesItemHandler> getBaublesHandler(Player player) {
        return player.getCapability(CapabilityBaubles.BAUBLES);
    }

    public static int isBaubleEquipped(Player player, Item bauble) {
        return BaublesAPI.getBaublesHandler(player).map(handler -> {
            for (int a = 0; a < handler.getSlots(); ++a) {
                if (handler.getStackInSlot(a).m_41619_() || handler.getStackInSlot(a).m_41720_() != bauble) continue;
                return a;
            }
            return -1;
        }).orElse(-1);
    }

    public static int getEmptySlotForBaubleType(Player playerEntity, BaubleType type) {
        IBaublesItemHandler itemHandler = (IBaublesItemHandler)BaublesAPI.getBaublesHandler(playerEntity).orElseThrow(NullPointerException::new);
        for (int i : type.getValidSlots()) {
            if (!itemHandler.getStackInSlot(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }
}

