/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.screens.steps;

import com.bisecthosting.mods.bhmenu.Config;
import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.bhdata.OrderData;
import com.bisecthosting.mods.bhmenu.bhdata.api.ApiData;
import com.bisecthosting.mods.bhmenu.bhdata.api.PlanService;
import com.bisecthosting.mods.bhmenu.screens.BHOrderScreen;
import com.bisecthosting.mods.bhmenu.screens.steps.ProcessStep;
import com.bisecthosting.mods.bhmenu.screens.steps.SelectPlanTypeStep;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.widget.Slider;

public class SelectPackageStep
extends ProcessStep {
    private Slider slider;
    private final PlanService planService;
    private int packageIndex;
    private final Component perfectPlan = new TranslatableComponent("step.select_package.plan");
    private final Component moveSlider = new TranslatableComponent("step.select_package.slider");

    public SelectPackageStep(OrderData orderData) {
        super(orderData);
        this.planService = orderData.isPremium ? (PlanService)ApiData.PLANS.getLeft() : (PlanService)ApiData.PLANS.getRight();
        this.packageIndex = this.getPackagePlanIndexFromRecommendations();
    }

    @Override
    public void init(BHOrderScreen screen, Consumer<GuiEventListener> children) {
        super.init(screen, children);
        int y = Mth.m_14045_((int)(screen.f_96544_ / 2 - 10), (int)120, (int)(screen.f_96544_ - 50));
        this.slider = new Slider(screen.f_96543_ / 2 - 100, y, 200, 20, (Component)new TextComponent(""), (Component)new TextComponent(""), 0.0, (double)(this.planService.plans.size() - 1), (double)this.packageIndex, false, false, b -> {}, slider -> {
            this.packageIndex = slider.getValueInt();
        });
        children.accept((GuiEventListener)new Button(screen.f_96543_ / 2 - 50, y + 30, 100, 20, (Component)new TranslatableComponent("step.select_package.order_plan"), b -> {
            this.orderData.packageId = this.getCurrentPlan().id;
            this.openOrderUrl();
            screen.getMinecraft().m_91152_(screen.parent);
        }));
        children.accept((GuiEventListener)this.slider);
    }

    @Override
    public void render(BHOrderScreen screen, Font font, PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        PlanService.PackagePlan currentPlan = this.getCurrentPlan();
        font.m_92889_(ms, this.perfectPlan, (float)(screen.f_96543_ - font.m_92852_((FormattedText)this.perfectPlan)) / 2.0f, (float)(this.slider.f_93621_ - 77), 0xFFFFFF);
        String plan = currentPlan.name;
        font.m_92883_(ms, plan, (float)(screen.f_96543_ - font.m_92895_(plan)) / 2.0f, (float)(this.slider.f_93621_ - 50), 0xFFFFFF);
        TranslatableComponent price = new TranslatableComponent("step.select_package.price", new Object[]{Float.valueOf(currentPlan.price)});
        font.m_92889_(ms, (Component)price, (float)(screen.f_96543_ - font.m_92852_((FormattedText)price)) / 2.0f, (float)(this.slider.f_93621_ - 40), 0xFFFFFF);
        font.m_92889_(ms, this.moveSlider, (float)(screen.f_96543_ - font.m_92852_((FormattedText)this.moveSlider)) / 2.0f, (float)(this.slider.f_93621_ - 15), 0xFFFFFF);
    }

    private void openOrderUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://bisecthosting.com/modredirect.php?pid=");
        urlBuilder.append(this.orderData.packageId);
        urlBuilder.append("&configoption[");
        urlBuilder.append(this.orderData.isPremium ? 29 : 32);
        urlBuilder.append("]=");
        urlBuilder.append(this.orderData.getJarId());
        urlBuilder.append("&source=mod");
        if (!((String)Config.partnerId.get()).isEmpty()) {
            urlBuilder.append("&aid=");
            urlBuilder.append((String)Config.partnerId.get());
        }
        ModRef.LOGGER.info("Setting up order link " + urlBuilder);
        Util.m_137581_().m_137646_(urlBuilder.toString());
    }

    private PlanService.PackagePlan getCurrentPlan() {
        return this.planService.plans.get(this.packageIndex);
    }

    private int getPackagePlanIndexFromRecommendations() {
        int recommendedRam = ApiData.RAM_RECOMMENDATIONS.get(this.orderData.getJarId()).getRamForPlayers(this.orderData.playerCount);
        int planIndex = 0;
        boolean planFound = false;
        for (PlanService.PackagePlan plan : this.planService.plans) {
            if (plan.ram / 1024 >= recommendedRam) {
                planFound = true;
                break;
            }
            ++planIndex;
        }
        if (!planFound) {
            planIndex = 0;
        }
        return planIndex;
    }

    @Override
    public void onClose(BHOrderScreen screen) {
        screen.setStep(new SelectPlanTypeStep(this.orderData));
    }
}

