/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.levelgen.SurfaceRules;
import terrablender.worldgen.TBSurfaceRuleData;
import terrablender.worldgen.surface.NamespacedSurfaceRuleSource;

public class SurfaceRuleManager {
    private static Map<RuleCategory, Map<String, SurfaceRules.RuleSource>> surfaceRules = Maps.newHashMap();
    private static Map<RuleCategory, SurfaceRules.RuleSource> defaultSurfaceRules = Maps.newHashMap();
    private static Map<RuleCategory, Map<RuleStage, List<Pair<Integer, SurfaceRules.RuleSource>>>> defaultSurfaceRuleInjections = Maps.newHashMap();

    public static void addSurfaceRules(RuleCategory category, String namespace, SurfaceRules.RuleSource rules) {
        surfaceRules.get((Object)category).put(namespace, rules);
    }

    public static void addToDefaultSurfaceRulesAtStage(RuleCategory category, RuleStage ruleStage, int priority, SurfaceRules.RuleSource rules) {
        defaultSurfaceRuleInjections.get((Object)category).get((Object)ruleStage).add((Pair<Integer, SurfaceRules.RuleSource>)Pair.of((Object)priority, (Object)rules));
    }

    public static void setDefaultSurfaceRules(RuleCategory category, SurfaceRules.RuleSource rules) {
        defaultSurfaceRules.put(category, rules);
    }

    public static SurfaceRules.RuleSource getNamespacedRules(RuleCategory category, SurfaceRules.RuleSource fallback) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"minecraft", (Object)SurfaceRuleManager.getDefaultSurfaceRules(category));
        builder.putAll(surfaceRules.get((Object)category));
        return new NamespacedSurfaceRuleSource(fallback, (Map<String, SurfaceRules.RuleSource>)builder.build());
    }

    public static List<SurfaceRules.RuleSource> getDefaultSurfaceRuleAdditionsForStage(RuleCategory category, RuleStage ruleStage) {
        return (List)defaultSurfaceRuleInjections.get((Object)category).get((Object)ruleStage).stream().sorted(Comparator.comparing(Pair::getFirst, Comparator.reverseOrder())).map(Pair::getSecond).collect(ImmutableList.toImmutableList());
    }

    public static SurfaceRules.RuleSource getDefaultSurfaceRules(RuleCategory category) {
        if (defaultSurfaceRules.containsKey((Object)category)) {
            return defaultSurfaceRules.get((Object)category);
        }
        if (category == RuleCategory.NETHER) {
            return TBSurfaceRuleData.nether();
        }
        return TBSurfaceRuleData.overworld();
    }

    static {
        for (RuleCategory category : RuleCategory.values()) {
            surfaceRules.put(category, Maps.newHashMap());
            HashMap ruleStages = Maps.newHashMap();
            for (RuleStage stage : RuleStage.values()) {
                ruleStages.put(stage, Lists.newArrayList());
            }
            defaultSurfaceRuleInjections.put(category, ruleStages);
        }
    }

    public static enum RuleCategory {
        OVERWORLD,
        NETHER;

    }

    public static enum RuleStage {
        BEFORE_BEDROCK,
        AFTER_BEDROCK;

    }
}

