/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import journeymap.client.JourneymapClient;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionDataStorageHandler;
import journeymap.common.nbt.cache.CacheStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;

public class RegionData {
    public static final String BIOME_TAG_NAME = "biome_name";
    public static final String BLOCK_TAG_NAME = "block";
    public static final String BLOCKSTATES_TAG_NAME = "blockstates";
    public static final String BLOCK_LIGHT_VALUE = "light_value";
    public static final String TOP_Y_TAG_NAME = "top_y";
    public static final String SURFACE_Y_TAG_NAME = "surface_y";
    public static final String BLOCK_COLOR_TAG_NAME = "block_color_";
    public static final String CHUNK_POS_NAME = "pos";
    protected final RegionCoord regionCoord;
    protected final MapType mapType;
    protected static boolean enabled;
    protected boolean loaded = false;
    protected final RegionDataStorageHandler.Key key;
    private final CacheStorage storage;

    public RegionData(RegionDataStorageHandler.Key key, CacheStorage storage) {
        this.regionCoord = key.rCoord;
        this.mapType = key.mapType;
        this.key = key;
        this.storage = storage;
        enabled = JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get();
    }

    public Biome getBiome(BlockPos blockPos) {
        CompoundTag blockData;
        if (enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(BIOME_TAG_NAME)) {
            String biomeName = blockData.m_128461_(BIOME_TAG_NAME);
            return BiomeHelper.getBiomeFromResourceString(biomeName);
        }
        return null;
    }

    public Integer getTopY(BlockPos blockPos) {
        CompoundTag blockData;
        if (enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(TOP_Y_TAG_NAME)) {
            return blockData.m_128451_(TOP_Y_TAG_NAME);
        }
        return blockPos.m_123342_();
    }

    public Integer getColor(BlockPos blockPos) {
        CompoundTag blockData;
        if (enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(BLOCK_COLOR_TAG_NAME)) {
            return blockData.m_128451_(BLOCK_COLOR_TAG_NAME);
        }
        return null;
    }

    public BlockState getBlockState(BlockPos blockPos) {
        if (enabled) {
            CompoundTag blockData = this.getBlockDataFromBlockPos(blockPos);
            return RegionData.getBlockState(blockData, blockPos, this.mapType);
        }
        return null;
    }

    public static BlockState getBlockState(CompoundTag blockData, BlockPos blockPos, MapType mapType) {
        if (enabled) {
            if (blockData.m_128441_(BLOCKSTATES_TAG_NAME) && !mapType.isUnderground()) {
                String key;
                CompoundTag states = RegionData.getBlockStates(blockData, mapType);
                if (states.m_128441_(key = String.valueOf(blockPos.m_123342_()))) {
                    CompoundTag blockState = states.m_128469_(key);
                    return NbtUtils.m_129241_((CompoundTag)blockState);
                }
                if (states.m_128431_().size() > 0 && states.m_128431_().stream().findFirst().isPresent()) {
                    CompoundTag blockState = states.m_128469_((String)states.m_128431_().stream().findFirst().get());
                    return NbtUtils.m_129241_((CompoundTag)blockState);
                }
            } else if (blockData.m_128441_(BLOCK_TAG_NAME)) {
                CompoundTag blockState = blockData.m_128469_(BLOCK_TAG_NAME);
                BlockState state = NbtUtils.m_129241_((CompoundTag)blockState);
                if (!mapType.isUnderground()) {
                    RegionData.setBlockState(blockData, state, blockPos, mapType);
                }
                return state;
            }
        }
        return null;
    }

    public void setBiome(CompoundTag blockData, Biome biome) {
        if (enabled) {
            String biomeName;
            String biomeString = BiomeHelper.getBiomeResource(biome).toString();
            if (blockData.m_128441_(BIOME_TAG_NAME) && (biomeName = blockData.m_128461_(BIOME_TAG_NAME)).equals(biomeString)) {
                return;
            }
            blockData.m_128359_(BIOME_TAG_NAME, biomeString);
        }
    }

    public void setBlockState(CompoundTag blockData, ChunkMD chunkMD, BlockPos pos) {
        BlockMD blockMD = chunkMD.getBlockMD(pos);
        if (!(!blockMD.hasNoShadow() || blockMD.isIgnore() || blockMD.isWater() || blockMD.isFluid() || blockMD.getBlockState().m_61147_().contains(DoublePlantBlock.f_52858_) || this.mapType.isUnderground())) {
            RegionData.setBlockState(blockData, chunkMD.getBlockMD(pos.m_7495_()).getBlockState(), pos.m_7495_(), this.mapType);
        }
        RegionData.setBlockState(blockData, blockMD.getBlockState(), pos, this.mapType);
    }

    private static void setBlockState(CompoundTag blockData, BlockState state, BlockPos pos, MapType mapType) {
        if (enabled && blockData != null) {
            if (mapType.isUnderground()) {
                CompoundTag blockState = NbtUtils.m_129202_((BlockState)state);
                blockData.m_128365_(BLOCK_TAG_NAME, (Tag)blockState);
            } else {
                CompoundTag states = RegionData.getBlockStates(blockData, mapType);
                CompoundTag blockState = NbtUtils.m_129202_((BlockState)state);
                states.m_128365_(String.valueOf(pos.m_123342_()), (Tag)blockState);
                blockData.m_128365_(BLOCKSTATES_TAG_NAME, (Tag)states);
            }
        }
    }

    public void setY(CompoundTag blockData, int topY) {
        if (enabled) {
            int savedTopY;
            if (blockData.m_128441_(TOP_Y_TAG_NAME) && (savedTopY = blockData.m_128451_(TOP_Y_TAG_NAME)) == topY) {
                return;
            }
            blockData.m_128405_(TOP_Y_TAG_NAME, topY);
        }
    }

    public void setLightValue(CompoundTag blockData, int light) {
        if (enabled) {
            int savedLight;
            if (blockData.m_128441_(BLOCK_LIGHT_VALUE) && (savedLight = blockData.m_128451_(BLOCK_LIGHT_VALUE)) == light) {
                return;
            }
            blockData.m_128405_(BLOCK_LIGHT_VALUE, light);
        }
    }

    public void setSurfaceY(CompoundTag blockData, int surfaceY) {
        if (enabled) {
            int savedTopY;
            if (blockData.m_128441_(SURFACE_Y_TAG_NAME) && (savedTopY = blockData.m_128451_(SURFACE_Y_TAG_NAME)) == surfaceY) {
                return;
            }
            blockData.m_128405_(SURFACE_Y_TAG_NAME, surfaceY);
        }
    }

    public void setBlockColor(CompoundTag blockData, int color, MapType.Name mapTypeName) {
    }

    private static CompoundTag getBlockStates(CompoundTag blockData, MapType mapType) {
        if (enabled) {
            if (mapType.isUnderground()) {
                if (blockData.m_128441_(BLOCK_TAG_NAME)) {
                    return blockData.m_128469_(BLOCK_TAG_NAME);
                }
            } else if (blockData.m_128441_(BLOCKSTATES_TAG_NAME)) {
                return blockData.m_128469_(BLOCKSTATES_TAG_NAME);
            }
            return new CompoundTag();
        }
        return null;
    }

    public CompoundTag getBlockDataFromBlockPos(ChunkPos chunkPos, CompoundTag chunk, int x, int z) {
        if (enabled && chunk != null) {
            return RegionData.getBlockDataForChunk(chunk, (chunkPos.f_45578_ << 4) + x, (chunkPos.f_45579_ << 4) + z);
        }
        return null;
    }

    public CompoundTag getBlockDataFromBlockPos(ChunkPos chunkPos, int x, int z) {
        CompoundTag chunk = this.getChunkNbt(chunkPos);
        if (enabled && chunk != null) {
            return RegionData.getBlockDataForChunk(chunk, (chunkPos.f_45578_ << 4) + x, (chunkPos.f_45579_ << 4) + z);
        }
        return null;
    }

    private CompoundTag getBlockDataFromBlockPos(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        CompoundTag chunk = this.getChunkNbt(chunkPos);
        return RegionData.getBlockDataForChunk(chunk, pos.m_123341_(), pos.m_123343_());
    }

    public CompoundTag getChunkNbt(ChunkPos chunkPos) {
        if (enabled) {
            CompoundTag chunkTag = this.storage.read(chunkPos);
            if (chunkTag == null) {
                chunkTag = new CompoundTag();
            }
            if (!chunkTag.m_128441_(CHUNK_POS_NAME)) {
                chunkTag.m_128356_(CHUNK_POS_NAME, chunkPos.m_45588_());
            }
            return chunkTag;
        }
        return null;
    }

    public static CompoundTag getBlockDataForChunk(CompoundTag chunk, int x, int z) {
        if (chunk != null) {
            CompoundTag blockTag;
            String blockTagName = x + "," + z;
            if (chunk.m_128441_(blockTagName)) {
                blockTag = chunk.m_128469_(blockTagName);
            } else {
                blockTag = new CompoundTag();
                chunk.m_128365_(blockTagName, (Tag)blockTag);
            }
            return blockTag;
        }
        return null;
    }

    public void writeChunk(ChunkPos chunkPos, CompoundTag tag) {
        this.storage.write(chunkPos, tag);
    }
}

