/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import journeymap.client.JourneymapClient;
import journeymap.client.api.event.DeathWaypointEvent;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class StateTickHandler {
    Minecraft mc = Minecraft.m_91087_();
    int counter = 0;
    private boolean deathpointCreated;

    public void onClientTick() {
        this.mc.m_91307_().m_6180_("journeymap");
        if (this.mc.f_91074_ != null && !this.mc.f_91074_.m_6084_()) {
            if (!this.deathpointCreated) {
                this.deathpointCreated = true;
                this.createDeathpoint();
            }
        } else {
            this.deathpointCreated = false;
        }
        try {
            if (this.counter == 20) {
                this.mc.m_91307_().m_6180_("mainTasks");
                JourneymapClient.getInstance().performMainThreadTasks();
                this.counter = 0;
                this.mc.m_91307_().m_7238_();
            } else if (this.counter == 10) {
                this.mc.m_91307_().m_6180_("multithreadTasks");
                if (JourneymapClient.getInstance().isMapping().booleanValue() && this.mc.f_91073_ != null) {
                    JourneymapClient.getInstance().performMultithreadTasks();
                }
                ++this.counter;
                this.mc.m_91307_().m_7238_();
            } else if (this.counter == 5 || this.counter == 15) {
                this.mc.m_91307_().m_6180_("clientApiEvents");
                ClientAPI.INSTANCE.getClientEventManager().fireNextClientEvents();
                ++this.counter;
                this.mc.m_91307_().m_7238_();
            } else {
                ++this.counter;
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Error during onClientTick: " + LogFormatter.toPartialString(t));
        }
        finally {
            this.mc.m_91307_().m_7238_();
        }
    }

    private void createDeathpoint() {
        try {
            LocalPlayer player = this.mc.f_91074_;
            if (player == null) {
                Journeymap.getLogger().error("Lost reference to player before Deathpoint could be created");
                return;
            }
            WaypointProperties waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
            boolean enabled = waypointProperties.managerEnabled.get() != false && waypointProperties.createDeathpoints.get() != false && JourneymapClient.getInstance().getStateHandler().isAllowDeathPoints();
            boolean cancelled = false;
            int buildMinY = player.f_19853_.m_6042_().m_156732_() + 2;
            double playerY = Math.max(Mth.m_14107_((double)player.m_20186_()), buildMinY);
            BlockPos pos = new BlockPos((double)Mth.m_14107_((double)player.m_20185_()), playerY, (double)Mth.m_14107_((double)player.m_20189_()));
            if (enabled) {
                ResourceKey dim = Minecraft.m_91087_().f_91074_.f_19853_.m_46472_();
                DeathWaypointEvent event = new DeathWaypointEvent(pos, (ResourceKey<Level>)dim);
                ClientAPI.INSTANCE.getClientEventManager().fireDeathpointEvent(event);
                if (!event.isCancelled()) {
                    Waypoint deathpoint = Waypoint.at(pos, Waypoint.Type.Death, dim.m_135782_().toString());
                    WaypointStore.INSTANCE.save(deathpoint, true);
                } else {
                    cancelled = true;
                }
            }
            Journeymap.getLogger().info(String.format("%s died at %s. Deathpoints enabled: %s. Deathpoint created: %s", player.m_7755_().getString(), pos, enabled, cancelled ? "cancelled" : Boolean.valueOf(true)));
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected Error in createDeathpoint(): " + LogFormatter.toString(t));
        }
    }
}

