/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawConfig;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.IMaxCountJigsawPiece;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class JigsawManager {
    public static Optional<PieceGenerator<YungJigsawConfig>> assembleJigsawStructure(PieceGeneratorSupplier.Context<YungJigsawConfig> jigsawContext, JigsawPlacement.PieceFactory pieceFactory, BlockPos startPos, boolean doBoundaryAdjustments, boolean useHeightmap, int structureBoundingBoxRadius) {
        int pieceCenterY;
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190068_(jigsawContext.f_197354_(), jigsawContext.f_197355_().f_45578_, jigsawContext.f_197355_().f_45579_);
        RegistryAccess registryAccess = jigsawContext.f_197360_();
        YungJigsawConfig config = (YungJigsawConfig)jigsawContext.f_197356_();
        ChunkGenerator chunkGenerator = jigsawContext.f_197352_();
        StructureManager structureManager = jigsawContext.f_197359_();
        LevelHeightAccessor levelHeightAccessor = jigsawContext.f_197357_();
        Predicate validBiomePredicate = jigsawContext.f_197358_();
        StructureFeature.m_67096_();
        Registry registry = registryAccess.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.m_55956_((Random)worldgenRandom);
        StructureTemplatePool structureTemplatePool = (StructureTemplatePool)registry.m_7745_(config.getStartPool());
        StructurePoolElement startPieceBlueprint = structureTemplatePool.m_210585_((Random)worldgenRandom);
        if (startPieceBlueprint == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece startPiece = pieceFactory.m_210300_(structureManager, startPieceBlueprint, startPos, startPieceBlueprint.m_210540_(), rotation, startPieceBlueprint.m_207470_(structureManager, startPos, rotation));
        BoundingBox pieceBoundingBox = startPiece.m_73547_();
        int pieceCenterX = (pieceBoundingBox.m_162399_() + pieceBoundingBox.m_162395_()) / 2;
        int pieceCenterZ = (pieceBoundingBox.m_162401_() + pieceBoundingBox.m_162398_()) / 2;
        int n = pieceCenterY = useHeightmap ? startPos.m_123342_() + chunkGenerator.m_156174_(pieceCenterX, pieceCenterZ, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor) : startPos.m_123342_();
        if (!validBiomePredicate.test(chunkGenerator.m_203495_(QuartPos.m_175400_((int)pieceCenterX), QuartPos.m_175400_((int)pieceCenterY), QuartPos.m_175400_((int)pieceCenterZ)))) {
            return Optional.empty();
        }
        int yAdjustment = pieceBoundingBox.m_162396_() + startPiece.m_72647_();
        startPiece.m_6324_(0, pieceCenterY - yAdjustment, 0);
        return Optional.of((structurePiecesBuilder, context) -> {
            ArrayList pieces = Lists.newArrayList();
            pieces.add(startPiece);
            if (config.getMaxDepth() <= 0) {
                return;
            }
            AABB aABB = new AABB((double)(pieceCenterX - structureBoundingBoxRadius), (double)(pieceCenterY - structureBoundingBoxRadius), (double)(pieceCenterZ - structureBoundingBoxRadius), (double)(pieceCenterX + structureBoundingBoxRadius + 1), (double)(pieceCenterY + structureBoundingBoxRadius + 1), (double)(pieceCenterZ + structureBoundingBoxRadius + 1));
            Placer placer = new Placer((Registry<StructureTemplatePool>)registry, config.getMaxDepth(), pieceFactory, chunkGenerator, structureManager, pieces, (Random)worldgenRandom);
            PieceState startPieceEntry = new PieceState(startPiece, (MutableObject<VoxelShape>)new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)aABB), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)pieceBoundingBox)), (BooleanOp)BooleanOp.f_82685_)), 0);
            placer.placing.addLast(startPieceEntry);
            while (!placer.placing.isEmpty()) {
                PieceState entry = placer.placing.removeFirst();
                placer.processPiece(entry.piece, entry.free, entry.depth, doBoundaryAdjustments, levelHeightAccessor);
            }
            pieces.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
        });
    }

    public static Optional<PieceGenerator<YungJigsawConfig>> assembleJigsawStructure(PieceGeneratorSupplier.Context<YungJigsawConfig> jigsawContext, JigsawPlacement.PieceFactory pieceFactory, BlockPos startPos, boolean doBoundaryAdjustments, boolean useHeightmap) {
        return JigsawManager.assembleJigsawStructure(jigsawContext, pieceFactory, startPos, doBoundaryAdjustments, useHeightmap, 80);
    }

    public static final class Placer {
        private final Registry<StructureTemplatePool> patternRegistry;
        private final int maxDepth;
        private final JigsawPlacement.PieceFactory pieceFactory;
        private final ChunkGenerator chunkGenerator;
        private final StructureManager structureManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final Random rand;
        public final Deque<PieceState> placing = Queues.newArrayDeque();
        private final Map<String, Integer> pieceCounts;
        private final Map<String, Integer> maxPieceCounts;
        private final int maxY;

        public Placer(Registry<StructureTemplatePool> patternRegistry, int maxDepth, JigsawPlacement.PieceFactory pieceFactory, ChunkGenerator chunkGenerator, StructureManager structureManager, List<? super PoolElementStructurePiece> pieces, Random rand) {
            this.patternRegistry = patternRegistry;
            this.maxDepth = maxDepth;
            this.pieceFactory = pieceFactory;
            this.chunkGenerator = chunkGenerator;
            this.structureManager = structureManager;
            this.pieces = pieces;
            this.rand = rand;
            this.pieceCounts = new HashMap<String, Integer>();
            this.maxPieceCounts = new HashMap<String, Integer>();
            this.maxY = 255;
        }

        public void processPiece(PoolElementStructurePiece piece, MutableObject<VoxelShape> voxelShape, int depth, boolean doBoundaryAdjustments, LevelHeightAccessor levelHeightAccessor) {
            StructurePoolElement pieceBlueprint = piece.m_209918_();
            BlockPos piecePos = piece.m_72646_();
            Rotation pieceRotation = piece.m_6830_();
            BoundingBox pieceBoundingBox = piece.m_73547_();
            int pieceMinY = pieceBoundingBox.m_162396_();
            MutableObject<VoxelShape> tempNewPieceVoxelShape = new MutableObject<VoxelShape>();
            List pieceJigsawBlocks = pieceBlueprint.m_207245_(this.structureManager, piecePos, pieceRotation, this.rand);
            for (StructureTemplate.StructureBlockInfo jigsawBlock : pieceJigsawBlocks) {
                StructurePoolElement generatedPiece;
                MutableObject<VoxelShape> pieceVoxelShape;
                Direction direction = JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_);
                BlockPos jigsawBlockPos = jigsawBlock.f_74675_;
                BlockPos jigsawBlockTargetPos = jigsawBlockPos.m_142300_(direction);
                ResourceLocation jigsawBlockPoolId = new ResourceLocation(jigsawBlock.f_74677_.m_128461_("pool"));
                Optional poolOptional = this.patternRegistry.m_6612_(jigsawBlockPoolId);
                if (!poolOptional.isPresent() || ((StructureTemplatePool)poolOptional.get()).m_210590_() == 0 && !Objects.equals(jigsawBlockPoolId, Pools.f_127186_.m_135782_())) {
                    YungsApiCommon.LOGGER.warn("Empty or nonexistent pool: {}", (Object)jigsawBlockPoolId);
                    continue;
                }
                ResourceLocation jigsawBlockFallback = ((StructureTemplatePool)poolOptional.get()).m_210573_();
                Optional fallbackOptional = this.patternRegistry.m_6612_(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((StructureTemplatePool)fallbackOptional.get()).m_210590_() == 0 && !Objects.equals(jigsawBlockFallback, Pools.f_127186_.m_135782_())) {
                    YungsApiCommon.LOGGER.warn("Empty or nonexistent fallback pool: {}", (Object)jigsawBlockFallback);
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.m_71051_((Vec3i)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    pieceVoxelShape = tempNewPieceVoxelShape;
                    if (tempNewPieceVoxelShape.getValue() == null) {
                        tempNewPieceVoxelShape.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)pieceBoundingBox)));
                    }
                } else {
                    pieceVoxelShape = voxelShape;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructureTemplatePoolAccessor)poolOptional.get()).getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, pieceVoxelShape, piece, depth, levelHeightAccessor)) != null) continue;
                this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructureTemplatePoolAccessor)fallbackOptional.get()).getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, pieceVoxelShape, piece, depth, levelHeightAccessor);
            }
        }

        private StructurePoolElement processList(List<Pair<StructurePoolElement, Integer>> candidatePieces, boolean doBoundaryAdjustments, StructureTemplate.StructureBlockInfo jigsawBlock, BlockPos jigsawBlockTargetPos, int pieceMinY, BlockPos jigsawBlockPos, MutableObject<VoxelShape> pieceVoxelShape, PoolElementStructurePiece piece, int depth, LevelHeightAccessor levelHeightAccessor) {
            StructureTemplatePool.Projection piecePlacementBehavior = piece.m_209918_().m_210539_();
            boolean isPieceRigid = piecePlacementBehavior == StructureTemplatePool.Projection.RIGID;
            int jigsawBlockRelativeY = jigsawBlockPos.m_123342_() - pieceMinY;
            int surfaceHeight = -1;
            int totalWeightSum = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0 && totalWeightSum > 0) {
                StructurePoolElement candidatePiece;
                Pair<StructurePoolElement, Integer> chosenPiecePair = null;
                int chosenWeight = this.rand.nextInt(totalWeightSum) + 1;
                for (Pair<StructurePoolElement, Integer> candidate : candidatePieces) {
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPiecePair = candidate;
                    break;
                }
                if ((candidatePiece = (StructurePoolElement)chosenPiecePair.getFirst()) == EmptyPoolElement.f_210175_) {
                    return null;
                }
                if (candidatePiece instanceof IMaxCountJigsawPiece) {
                    String pieceName = ((IMaxCountJigsawPiece)candidatePiece).getName();
                    int maxCount = ((IMaxCountJigsawPiece)candidatePiece).getMaxCount();
                    if (this.maxPieceCounts.containsKey(pieceName) && this.maxPieceCounts.get(pieceName) != maxCount) {
                        YungsApiCommon.LOGGER.error("YUNG Jigsaw piece with name {} and max_count {} does not match stored max_count of {}!", (Object)pieceName, (Object)maxCount, (Object)this.maxPieceCounts.get(pieceName));
                        YungsApiCommon.LOGGER.error("This can happen when multiple pieces across pools use the same name, but have different max_count values.");
                        YungsApiCommon.LOGGER.error("Please change these max_count values to match. Using max_count={} for now...", (Object)maxCount);
                    }
                    this.maxPieceCounts.put(pieceName, maxCount);
                    if (this.pieceCounts.getOrDefault(pieceName, 0) >= maxCount) {
                        totalWeightSum -= ((Integer)chosenPiecePair.getSecond()).intValue();
                        candidatePieces.remove(chosenPiecePair);
                        continue;
                    }
                }
                for (Rotation rotation : Rotation.m_55958_((Random)this.rand)) {
                    List candidateJigsawBlocks = candidatePiece.m_207245_(this.structureManager, BlockPos.f_121853_, rotation, this.rand);
                    BoundingBox tempCandidateBoundingBox = candidatePiece.m_207470_(this.structureManager, BlockPos.f_121853_, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.m_71057_() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.m_71051_((Vec3i)pieceCandidateJigsawBlock.f_74675_.m_142300_(JigsawBlock.m_54250_((BlockState)pieceCandidateJigsawBlock.f_74676_)))) {
                            return 0;
                        }
                        ResourceLocation candidateTargetPool = new ResourceLocation(pieceCandidateJigsawBlock.f_74677_.m_128461_("pool"));
                        Optional candidateTargetPoolOptional = this.patternRegistry.m_6612_(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(StructureTemplatePool2 -> this.patternRegistry.m_6612_(StructureTemplatePool2.m_210573_()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(structureTemplatePool -> structureTemplatePool.m_210580_(this.structureManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(structureTemplatePool -> structureTemplatePool.m_210580_(this.structureManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.StructureBlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)jigsawBlock, (StructureTemplate.StructureBlockInfo)candidateJigsawBlock)) continue;
                        BlockPos candidateJigsawBlockPos = candidateJigsawBlock.f_74675_;
                        BlockPos candidateJigsawBlockRelativePos = jigsawBlockTargetPos.m_141950_((Vec3i)candidateJigsawBlockPos);
                        BoundingBox candidateBoundingBox = candidatePiece.m_207470_(this.structureManager, candidateJigsawBlockRelativePos, rotation);
                        StructureTemplatePool.Projection candidatePlacementBehavior = candidatePiece.m_210539_();
                        boolean isCandidateRigid = candidatePlacementBehavior == StructureTemplatePool.Projection.RIGID;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.m_123342_();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_).m_122430_();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.m_156174_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.m_162396_();
                        BoundingBox adjustedCandidateBoundingBox = candidateBoundingBox.m_71045_(0, candidatePieceYOffsetNeeded, 0);
                        BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.m_142082_(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.m_162400_() - adjustedCandidateBoundingBox.m_162396_());
                            ((BoundingBoxAccessor)adjustedCandidateBoundingBox).setMaxY(adjustedCandidateBoundingBox.m_162396_() + k2);
                        }
                        if (adjustedCandidateBoundingBox.m_162400_() > this.maxY || Shapes.m_83157_((VoxelShape)((VoxelShape)pieceVoxelShape.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)adjustedCandidateBoundingBox).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                        pieceVoxelShape.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)pieceVoxelShape.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)adjustedCandidateBoundingBox)), (BooleanOp)BooleanOp.f_82685_));
                        int newPieceGroundLevelDelta = piece.m_72647_();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.m_210540_();
                        PoolElementStructurePiece newPiece = this.pieceFactory.m_210300_(this.structureManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.m_156174_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.m_209916_(new JigsawJunction(jigsawBlockTargetPos.m_123341_(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.m_123343_(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.m_209916_(new JigsawJunction(jigsawBlockPos.m_123341_(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.m_123343_(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.pieces.add((PoolElementStructurePiece)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.placing.addLast(new PieceState(newPiece, pieceVoxelShape, depth + 1));
                        }
                        if (candidatePiece instanceof IMaxCountJigsawPiece) {
                            String pieceName = ((IMaxCountJigsawPiece)candidatePiece).getName();
                            this.pieceCounts.put(pieceName, this.pieceCounts.getOrDefault(pieceName, 0) + 1);
                        }
                        return candidatePiece;
                    }
                }
                totalWeightSum -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }

    public static final class PieceState {
        public final PoolElementStructurePiece piece;
        public final MutableObject<VoxelShape> free;
        public final int depth;

        public PieceState(PoolElementStructurePiece piece, MutableObject<VoxelShape> voxelShape, int depth) {
            this.piece = piece;
            this.free = voxelShape;
            this.depth = depth;
        }
    }
}

