/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.explosion;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.explosion.ExplosionTickHandler;
import com.buuz135.industrial.utils.explosion.ShortPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class ExplosionHelper {
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private final ServerLevel serverWorld;
    public LinkedList<HashSet<Integer>> toRemove = new LinkedList();
    private BlockPos start;
    private ShortPos shortPos;
    private HashSet<Integer> blocksToUpdate = new HashSet();
    private HashSet<Integer> lightUpdates = new HashSet();
    private HashSet<Integer> tilesToRemove = new HashSet();
    private HashMap<ChunkPos, LevelChunk> chunkCache = new HashMap();

    public ExplosionHelper(ServerLevel serverWorld, BlockPos start, ShortPos shortPos) {
        this.serverWorld = serverWorld;
        this.start = start;
        this.shortPos = shortPos;
    }

    public void setBlocksForRemoval(LinkedList<HashSet<Integer>> list) {
        this.toRemove = list;
    }

    public void addBlocksForUpdate(Collection<Integer> blocksToUpdate) {
        this.blocksToUpdate.addAll(blocksToUpdate);
    }

    private LevelChunk removeBlock(BlockPos pos) {
        LevelChunk chunk = this.getChunk(pos);
        BlockState oldState = chunk.m_8055_(pos);
        if (oldState.m_60734_() instanceof EntityBlock) {
            this.serverWorld.m_7471_(pos, false);
            this.serverWorld.m_5518_().m_142202_(pos);
            return chunk;
        }
        LevelChunkSection storage = this.getBlockStorage(pos);
        if (storage != null) {
            storage.m_62986_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF, AIR);
        }
        this.setChunkModified(pos);
        this.serverWorld.m_5518_().m_142202_(pos);
        return chunk;
    }

    public void setChunkModified(BlockPos blockPos) {
        LevelChunk chunk = this.getChunk(blockPos);
        this.setChunkModified(chunk);
    }

    public void setChunkModified(LevelChunk chunk) {
    }

    private LevelChunk getChunk(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        if (!this.chunkCache.containsKey(cp)) {
            this.chunkCache.put(cp, this.serverWorld.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4));
        }
        return this.chunkCache.get(cp);
    }

    private LevelChunkSection getBlockStorage(BlockPos pos) {
        LevelChunk chunk = this.getChunk(pos);
        return chunk.m_7103_()[pos.m_123342_() >> 4];
    }

    public void finish() {
        IndustrialForegoing.LOGGER.debug("EH: finish");
        RemovalProcess process = new RemovalProcess(this);
        ExplosionTickHandler.removalProcessList.add(process);
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.serverWorld.m_46859_(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        LevelChunkSection storage = this.getBlockStorage(pos);
        if (storage == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return storage.m_62982_(pos.m_123341_() & 0xF, pos.m_123342_() & 0xF, pos.m_123343_() & 0xF);
    }

    public static class RemovalProcess {
        public boolean isDead = false;
        int index = 0;
        private ExplosionHelper helper;
        private MinecraftServer server;
        private int blocksToUpdatePointer = 0;
        private List<Integer> blocksToRmv = new ArrayList<Integer>();
        private long start;

        public RemovalProcess(ExplosionHelper helper) {
            this.helper = helper;
            this.server = helper.serverWorld.m_142572_();
            this.start = System.currentTimeMillis();
        }

        public void updateProcess() {
            long startTime = Util.m_137550_();
            HashSet<LevelChunk> chunks = new HashSet<LevelChunk>();
            while (Util.m_137550_() - startTime < 40L && this.helper.toRemove.size() > 0) {
                IndustrialForegoing.LOGGER.debug("Processing chunks at rad: " + this.index);
                HashSet<Integer> set = this.helper.toRemove.removeFirst();
                for (int pos : set) {
                    BlockPos blockPos = this.helper.shortPos.getActualPos(pos);
                    if (!BlockUtils.canBlockBeBrokenPlugin((Level)this.helper.serverWorld, blockPos)) continue;
                    chunks.add(this.helper.removeBlock(this.helper.shortPos.getActualPos(pos)));
                }
                ++this.index;
            }
            this.finishChunks(chunks);
            if (this.helper.toRemove.isEmpty()) {
                if (this.blocksToRmv.isEmpty()) {
                    this.blocksToRmv = new ArrayList<Integer>(this.helper.blocksToUpdate);
                }
                if (this.blocksToUpdatePointer < this.helper.blocksToUpdate.size()) {
                    this.updateBlocks();
                } else {
                    IndustrialForegoing.LOGGER.info("Explosion Completed in " + (System.currentTimeMillis() - this.start) / 1000L + "s");
                    this.isDead = true;
                    IndustrialForegoing.LOGGER.info("Explosion done");
                }
            }
        }

        public void finishChunks(HashSet<LevelChunk> chunks) {
            for (LevelChunk chunk : chunks) {
                chunk.m_8092_(true);
                ThreadedLevelLightEngine threadedLevelLightEngine = (ThreadedLevelLightEngine)this.helper.serverWorld.m_5518_();
            }
        }

        private void updateBlocks() {
            IndustrialForegoing.LOGGER.debug("Updating Blocks");
            int amount = 1000;
            for (int i = 0; i < amount; ++i) {
                if (this.blocksToUpdatePointer + i >= this.helper.blocksToUpdate.size()) continue;
                try {
                    int pos = this.blocksToRmv.get(this.blocksToUpdatePointer + i);
                    BlockState state = this.helper.serverWorld.m_8055_(this.helper.shortPos.getActualPos(pos));
                    if (state.m_60734_() instanceof FallingBlock) {
                        state.m_60734_().m_7458_(state, this.helper.serverWorld, this.helper.shortPos.getActualPos(pos), this.helper.serverWorld.f_46441_);
                    }
                    state.m_60690_((Level)this.helper.serverWorld, this.helper.shortPos.getActualPos(pos), Blocks.f_50016_, this.helper.shortPos.getActualPos(pos).m_7494_(), false);
                    continue;
                }
                catch (Throwable e) {
                    IndustrialForegoing.LOGGER.error((Object)e);
                }
            }
            this.blocksToUpdatePointer += amount;
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

