/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.utils.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class ChorusCache {
    private List<BlockPos> chorus;
    private Level world;

    public ChorusCache(Level world, BlockPos current) {
        this.world = world;
        this.chorus = new ArrayList<BlockPos>();
        Stack<BlockPos> chorus = new Stack<BlockPos>();
        chorus.push(current);
        while (!chorus.isEmpty()) {
            BlockPos checking = (BlockPos)chorus.pop();
            if (!BlockUtils.isChorus(world, checking)) continue;
            Iterable area = BlockPos.m_121940_((BlockPos)checking.m_142300_(Direction.DOWN).m_142300_(Direction.SOUTH).m_142300_(Direction.WEST), (BlockPos)checking.m_142300_(Direction.UP).m_142300_(Direction.NORTH).m_142300_(Direction.EAST));
            for (BlockPos blockPos : area) {
                if (!BlockUtils.isChorus(world, blockPos) || this.chorus.contains(blockPos) || !(blockPos.m_123331_((Vec3i)current) <= 100.0)) continue;
                chorus.push(blockPos);
                this.chorus.add(blockPos);
            }
        }
    }

    public boolean isFullyGrown() {
        return this.chorus.stream().map(blockpos -> this.world.m_8055_(blockpos)).allMatch(blockState -> blockState.m_60734_().equals(Blocks.f_50490_) || blockState.m_60734_().equals(Blocks.f_50491_) && (Integer)blockState.m_61143_((Property)ChorusFlowerBlock.f_51647_) == 5);
    }

    public List<ItemStack> chop() {
        NonNullList stacks = NonNullList.m_122779_();
        int maxY = this.getTopRowY();
        this.chorus.stream().filter(pos -> pos.m_123342_() == maxY).forEach(pos -> this.chop((NonNullList<ItemStack>)stacks, (BlockPos)pos));
        this.chorus.removeIf(pos -> pos.m_123342_() == maxY);
        return stacks;
    }

    public void chop(NonNullList<ItemStack> stacks, BlockPos p) {
        if (BlockUtils.isChorus(this.world, p)) {
            if (this.world.m_8055_(p).m_60734_().equals(Blocks.f_50491_)) {
                stacks.add((Object)new ItemStack((ItemLike)Blocks.f_50491_));
            } else {
                stacks.addAll(BlockUtils.getBlockDrops(this.world, p));
            }
            this.world.m_46597_(p, Blocks.f_50016_.m_49966_());
        }
    }

    public int getTopRowY() {
        int i = 0;
        for (BlockPos blockPos : this.chorus) {
            if (blockPos.m_123342_() <= i) continue;
            i = blockPos.m_123342_();
        }
        return i;
    }

    public List<BlockPos> getChorus() {
        return this.chorus;
    }
}

