/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.utils.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.tags.IReverseTag;

public class ItemStackUtils {
    public static ResourceLocation getOreTag(ItemStack stack) {
        Item item = stack.m_41720_();
        for (ResourceLocation resourceLocation : (List)ForgeRegistries.ITEMS.tags().getReverseTag((IForgeRegistryEntry)stack.m_41720_()).map(IReverseTag::getTagKeys).map(tagKeyStream -> tagKeyStream.map(TagKey::f_203868_).collect(Collectors.toList())).orElse(new ArrayList())) {
            if (!resourceLocation.toString().startsWith("forge:raw_materials/")) continue;
            return resourceLocation;
        }
        return null;
    }

    public static boolean isInventoryFull(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static boolean isChorusFlower(ItemStack stack) {
        return !Block.m_49814_((Item)stack.m_41720_()).equals(Blocks.f_50016_) && Block.m_49814_((Item)stack.m_41720_()).equals(Blocks.f_50491_);
    }

    public static boolean acceptsFluidItem(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(ItemStack stack) {
        return ColorUtils.getColorFrom(Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 0).m_6160_());
    }
}

