/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.model;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.client.model.ConveyorModelData;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

public class ConveyorBlockModel
implements IDynamicBakedModel {
    public static Cache<Pair<Pair<String, Pair<Direction, Direction>>, Direction>, List<BakedQuad>> CACHE = CacheBuilder.newBuilder().build();
    private VertexFormat format;
    private BakedModel previousConveyor;
    private Map<Direction, List<BakedQuad>> prevQuads = new HashMap<Direction, List<BakedQuad>>();

    public ConveyorBlockModel(BakedModel previousConveyor) {
        this.previousConveyor = previousConveyor;
        this.format = DefaultVertexFormat.f_85811_;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (state == null) {
            if (!this.prevQuads.containsKey(side)) {
                this.prevQuads.put(side, this.previousConveyor.m_6840_(state, side, rand));
            }
            return this.prevQuads.get(side);
        }
        if (!this.prevQuads.containsKey(side)) {
            this.prevQuads.put(side, this.previousConveyor.m_6840_(state, side, rand));
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>((Collection)this.prevQuads.get(side));
        if (extraData.hasProperty(ConveyorModelData.UPGRADE_PROPERTY)) {
            for (ConveyorUpgrade upgrade : ((ConveyorModelData)extraData.getData(ConveyorModelData.UPGRADE_PROPERTY)).getUpgrades().values()) {
                if (upgrade == null) continue;
                List upgradeQuads = (List)CACHE.getIfPresent((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getRegistryName().toString(), (Object)Pair.of((Object)upgrade.getSide(), (Object)((Direction)state.m_61143_((Property)ConveyorBlock.FACING)))), (Object)side));
                if (upgradeQuads == null) {
                    try {
                        BakedModel model = ModuleTransportStorage.CONVEYOR_UPGRADES_CACHE.get(upgrade.getFactory().getModel(upgrade.getSide(), (Direction)state.m_61143_((Property)ConveyorBlock.FACING)));
                        upgradeQuads = model.getQuads(state, side, rand, extraData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    CACHE.put((Object)Pair.of((Object)Pair.of((Object)upgrade.getFactory().getRegistryName().toString(), (Object)Pair.of((Object)upgrade.getSide(), (Object)((Direction)state.m_61143_((Property)ConveyorBlock.FACING)))), (Object)side), (Object)upgradeQuads);
                }
                if (upgradeQuads.isEmpty()) continue;
                quads.addAll(upgradeQuads);
            }
        }
        return quads;
    }

    public boolean m_7541_() {
        return this.previousConveyor.m_7541_();
    }

    public boolean m_7539_() {
        return this.previousConveyor.m_7539_();
    }

    public boolean m_7547_() {
        return this.previousConveyor.m_7547_();
    }

    public boolean m_7521_() {
        return this.previousConveyor.m_7521_();
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.previousConveyor.m_6160_();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return this.previousConveyor.m_7343_();
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack mat) {
        return this.previousConveyor.handlePerspective(cameraTransformType, mat);
    }

    public ItemTransforms m_7442_() {
        return this.previousConveyor.m_7442_();
    }
}

