/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.block.resourceproduction.tile.MaterialStoneWorkFactoryTile;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class StoneWorkCategory
implements IRecipeCategory<Wrapper> {
    private final IGuiHelper helper;

    public StoneWorkCategory(IGuiHelper helper) {
        this.helper = helper;
    }

    public ResourceLocation getUid() {
        return IndustrialRecipeTypes.STONE_WORK.getUid();
    }

    public Class<? extends Wrapper> getRecipeClass() {
        return IndustrialRecipeTypes.STONE_WORK.getRecipeClass();
    }

    public RecipeType<Wrapper> getRecipeType() {
        return IndustrialRecipeTypes.STONE_WORK;
    }

    public Component getTitle() {
        return new TranslatableComponent(((Block)((RegistryObject)ModuleResourceProduction.MATERIAL_STONEWORK_FACTORY.getLeft()).get()).m_7705_());
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 94, 0, 160, 26);
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Wrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredient(VanillaTypes.ITEM, (Object)recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 139, 5).addIngredient(VanillaTypes.ITEM, (Object)recipe.getOutput());
        for (int i = 0; i < recipe.getModes().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 29 + i * 24, 5).addIngredient(VanillaTypes.ITEM, (Object)recipe.getModes().get(i).getIcon());
        }
    }

    public static class Wrapper {
        private final ItemStack input;
        private final List<MaterialStoneWorkFactoryTile.StoneWorkAction> modes;
        private final ItemStack output;

        public Wrapper(ItemStack input, List<MaterialStoneWorkFactoryTile.StoneWorkAction> modes, ItemStack output) {
            this.input = input;
            this.modes = modes;
            this.output = output;
            while (this.modes.size() < 4) {
                this.modes.add(MaterialStoneWorkFactoryTile.ACTION_RECIPES[4]);
            }
        }

        public ItemStack getInput() {
            return this.input;
        }

        public List<MaterialStoneWorkFactoryTile.StoneWorkAction> getModes() {
            return this.modes;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

