/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class FluidExtractorCategory
implements IRecipeCategory<FluidExtractorRecipe> {
    private IGuiHelper guiHelper;
    private IDrawable tankOverlay;

    public FluidExtractorCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.tankOverlay = guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 1, 207, 12, 48);
    }

    public ResourceLocation getUid() {
        return IndustrialRecipeTypes.FLUID_EXTRACTOR.getUid();
    }

    public Class<? extends FluidExtractorRecipe> getRecipeClass() {
        return IndustrialRecipeTypes.FLUID_EXTRACTOR.getRecipeClass();
    }

    public RecipeType<FluidExtractorRecipe> getRecipeType() {
        return IndustrialRecipeTypes.FLUID_EXTRACTOR;
    }

    public Component getTitle() {
        return new TranslatableComponent(((Block)((RegistryObject)ModuleCore.FLUID_EXTRACTOR.getLeft()).get()).m_7705_());
    }

    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 27, 76, 50).addPadding(0, 0, 0, 74).build();
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidExtractorRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addIngredients(VanillaTypes.ITEM, new ArrayList(recipe.input.m_6223_()));
        ItemStack out = new ItemStack((ItemLike)recipe.result);
        if (!out.m_41619_()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 27, 34).addIngredient(VanillaTypes.ITEM, (Object)out)).setBackground((IDrawable)this.guiHelper.getSlotDrawable(), -1, -1);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 57, 1).setFluidRenderer(20, false, 12, 48).setOverlay(this.tankOverlay, 0, 0).addIngredient(VanillaTypes.FLUID, (Object)recipe.output);
    }

    public void draw(FluidExtractorRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        Minecraft.m_91087_().f_91062_.m_92883_(stack, ChatFormatting.DARK_GRAY + "Production: ", 80.0f, 6.0f, 0xFFFFFF);
        Font font = Minecraft.m_91087_().f_91062_;
        String string = ChatFormatting.DARK_GRAY + recipe.output.getAmount() + "mb/work";
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        font.m_92883_(stack, string, 80.0f, (float)(6 + (9 + 2) * 1), 0xFFFFFF);
        Font font2 = Minecraft.m_91087_().f_91062_;
        String string2 = ChatFormatting.DARK_GRAY + "Tripled when";
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        font2.m_92883_(stack, string2, 80.0f, (float)(6 + (9 + 2) * 2), 0xFFFFFF);
        Font font3 = Minecraft.m_91087_().f_91062_;
        String string3 = ChatFormatting.DARK_GRAY + "powered";
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        font3.m_92883_(stack, string3, 80.0f, (float)(6 + (9 + 2) * 3), 0xFFFFFF);
    }

    public List<Component> getTooltipStrings(FluidExtractorRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 78.0 && mouseX <= 140.0 && mouseY >= 5.0 && mouseY <= 25.0) {
            return Arrays.asList(new TextComponent("Production rate"));
        }
        return new ArrayList<Component>();
    }
}

