/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.module;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.BlackHoleControllerBlock;
import com.buuz135.industrial.block.transportstorage.BlackHoleTankBlock;
import com.buuz135.industrial.block.transportstorage.BlackHoleUnitBlock;
import com.buuz135.industrial.block.transportstorage.ConveyorBlock;
import com.buuz135.industrial.block.transportstorage.TransporterBlock;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorBlinkingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorBouncingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorDetectorUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorDroppingUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorExtractionUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorInsertionUpgrade;
import com.buuz135.industrial.block.transportstorage.conveyor.ConveyorSplittingUpgrade;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterFluidType;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterItemType;
import com.buuz135.industrial.block.transportstorage.transporter.TransporterWorldType;
import com.buuz135.industrial.gui.conveyor.ContainerConveyor;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.gui.transporter.ContainerTransporter;
import com.buuz135.industrial.gui.transporter.GuiTransporter;
import com.buuz135.industrial.item.ItemConveyorUpgrade;
import com.buuz135.industrial.item.ItemTransporterType;
import com.buuz135.industrial.module.IModule;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.proxy.client.model.ConveyorBlockModel;
import com.buuz135.industrial.proxy.client.model.TransporterBlockModel;
import com.google.common.collect.ImmutableMap;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import com.hrznstudio.titanium.tab.AdvancedTitaniumTab;
import java.util.HashMap;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class ModuleTransportStorage
implements IModule {
    public static AdvancedTitaniumTab TAB_TRANSPORT = new AdvancedTitaniumTab("industrialforegoing_transport", true);
    public static ConveyorUpgradeFactory upgrade_extraction = new ConveyorExtractionUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_insertion = new ConveyorInsertionUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_detector = new ConveyorDetectorUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_bouncing = new ConveyorBouncingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_dropping = new ConveyorDroppingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_blinking = new ConveyorBlinkingUpgrade.Factory();
    public static ConveyorUpgradeFactory upgrade_splitting = new ConveyorSplittingUpgrade.Factory();
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> CONVEYOR = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile("conveyor", () -> new ConveyorBlock((CreativeModeTab)TAB_TRANSPORT));
    public static HashMap<ResourceLocation, BakedModel> CONVEYOR_UPGRADES_CACHE = new HashMap();
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_COMMON = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(Rarity.COMMON.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(Rarity.COMMON));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_PITY = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(ModuleCore.PITY_RARITY.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(ModuleCore.PITY_RARITY));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_SIMPLE = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(ModuleCore.SIMPLE_RARITY.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(ModuleCore.SIMPLE_RARITY));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_ADVANCED = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(ModuleCore.ADVANCED_RARITY.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(ModuleCore.ADVANCED_RARITY));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_UNIT_SUPREME = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(ModuleCore.SUPREME_RARITY.name().toLowerCase() + "_black_hole_unit", () -> new BlackHoleUnitBlock(ModuleCore.SUPREME_RARITY));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_COMMON = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(Rarity.COMMON.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(Rarity.COMMON));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_PITY = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(ModuleCore.PITY_RARITY.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(ModuleCore.PITY_RARITY));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_SIMPLE = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(ModuleCore.SIMPLE_RARITY.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(ModuleCore.SIMPLE_RARITY));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_ADVANCED = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(ModuleCore.ADVANCED_RARITY.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(ModuleCore.ADVANCED_RARITY));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_TANK_SUPREME = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile(ModuleCore.SUPREME_RARITY.name().toLowerCase() + "_black_hole_tank", () -> new BlackHoleTankBlock(ModuleCore.SUPREME_RARITY));
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> BLACK_HOLE_CONTROLLER = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile("black_hole_controller", () -> new BlackHoleControllerBlock());
    public static TransporterTypeFactory ITEM_TRANSPORTER = new TransporterItemType.Factory();
    public static TransporterTypeFactory FLUID_TRANSPORTER = new TransporterFluidType.Factory();
    public static TransporterTypeFactory WORLD_TRANSPORTER = new TransporterWorldType.Factory();
    public static Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> TRANSPORTER = IndustrialForegoing.INSTANCE.getRegistries().registerBlockWithTile("transporter", () -> new TransporterBlock((CreativeModeTab)TAB_TRANSPORT));
    public static HashMap<ResourceLocation, BakedModel> TRANSPORTER_CACHE = new HashMap();

    @Override
    public void generateFeatures(DeferredRegistryHelper registryHelper) {
        TAB_TRANSPORT.addIconStack(() -> new ItemStack((ItemLike)((RegistryObject)CONVEYOR.getLeft()).orElse((Object)Blocks.f_50069_)));
        registryHelper.registerGeneric(MenuType.class, "conveyor", () -> IForgeMenuType.create(ContainerConveyor::new));
        ConveyorUpgradeFactory.FACTORIES.forEach(conveyorUpgradeFactory -> registryHelper.registerGeneric(Item.class, "conveyor_" + conveyorUpgradeFactory.getRegistryName().m_135815_() + "_upgrade", () -> new ItemConveyorUpgrade((ConveyorUpgradeFactory)((Object)conveyorUpgradeFactory), (CreativeModeTab)TAB_TRANSPORT)));
        registryHelper.registerGeneric(MenuType.class, "transporter", () -> IForgeMenuType.create(ContainerTransporter::new));
        TransporterTypeFactory.FACTORIES.forEach(transporterTypeFactory -> registryHelper.registerGeneric(Item.class, transporterTypeFactory.getRegistryName().m_135815_() + "_transporter_type", () -> new ItemTransporterType((TransporterTypeFactory)((Object)transporterTypeFactory), (CreativeModeTab)TAB_TRANSPORT)));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::onClient);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void conveyorBake(ModelBakeEvent event) {
        for (ResourceLocation resourceLocation : event.getModelRegistry().keySet()) {
            if (!resourceLocation.m_135827_().equals("industrialforegoing") || !resourceLocation.m_135815_().contains("conveyor") || resourceLocation.m_135815_().contains("upgrade")) continue;
            event.getModelRegistry().put(resourceLocation, new ConveyorBlockModel((BakedModel)event.getModelRegistry().get(resourceLocation)));
        }
        for (ConveyorUpgradeFactory conveyorUpgradeFactory : ConveyorUpgradeFactory.FACTORIES) {
            for (Direction upgradeFacing : conveyorUpgradeFactory.getValidFacings()) {
                for (Direction conveyorFacing : ConveyorBlock.FACING.m_6908_()) {
                    try {
                        ResourceLocation resourceLocation = conveyorUpgradeFactory.getModel(upgradeFacing, conveyorFacing);
                        UnbakedModel unbakedModel = event.getModelLoader().m_119341_(resourceLocation);
                        CONVEYOR_UPGRADES_CACHE.put(resourceLocation, unbakedModel.m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), (ModelState)new SimpleModelState(ImmutableMap.of()), resourceLocation));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void textureStitch(TextureStitchEvent.Pre pre) {
        if (pre.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            ConveyorUpgradeFactory.FACTORIES.forEach(conveyorUpgradeFactory -> conveyorUpgradeFactory.getTextures().forEach(arg_0 -> ((TextureStitchEvent.Pre)pre).addSprite(arg_0)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void transporterBake(ModelBakeEvent event) {
        for (ResourceLocation resourceLocation : event.getModelRegistry().keySet()) {
            if (!resourceLocation.m_135827_().equals("industrialforegoing") || !resourceLocation.m_135815_().contains("transporter") || resourceLocation.m_135815_().contains("transporters/") || resourceLocation.m_135815_().contains("type")) continue;
            event.getModelRegistry().put(resourceLocation, new TransporterBlockModel((BakedModel)event.getModelRegistry().get(resourceLocation)));
        }
        for (TransporterTypeFactory transporterTypeFactory : TransporterTypeFactory.FACTORIES) {
            String itemRL = "industrialforegoing:" + transporterTypeFactory.getRegistryName().m_135815_() + "_transporter_type#inventory";
            for (Direction upgradeFacing : transporterTypeFactory.getValidFacings()) {
                for (TransporterTypeFactory.TransporterAction actions : TransporterTypeFactory.TransporterAction.values()) {
                    try {
                        ResourceLocation resourceLocation = transporterTypeFactory.getModel(upgradeFacing, actions);
                        UnbakedModel unbakedModel = event.getModelLoader().m_119341_(resourceLocation);
                        TRANSPORTER_CACHE.put(resourceLocation, unbakedModel.m_7611_((ModelBakery)event.getModelLoader(), ForgeModelBakery.defaultTextureGetter(), (ModelState)new SimpleModelState(ImmutableMap.of()), resourceLocation));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            for (ResourceLocation resourceLocation : event.getModelRegistry().keySet()) {
                if (!resourceLocation.m_135827_().equals("industrialforegoing") || !resourceLocation.toString().equals(itemRL)) continue;
                event.getModelRegistry().put(resourceLocation, TRANSPORTER_CACHE.get(transporterTypeFactory.getItemModel()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void transporterTextureStitch(TextureStitchEvent.Pre pre) {
        if (pre.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            TransporterTypeFactory.FACTORIES.forEach(transporterTypeFactory -> transporterTypeFactory.getTextures().forEach(arg_0 -> ((TextureStitchEvent.Pre)pre).addSprite(arg_0)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetupConveyor(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(ContainerConveyor.TYPE, GuiConveyor::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetupTransporter(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(ContainerTransporter.TYPE, GuiTransporter::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClient() {
        EventManager.mod(FMLClientSetupEvent.class).process(this::onClientSetupConveyor).subscribe();
        EventManager.mod(ModelBakeEvent.class).process(this::conveyorBake).subscribe();
        EventManager.mod(TextureStitchEvent.Pre.class).process(this::textureStitch).subscribe();
        EventManager.mod(ModelBakeEvent.class).process(this::transporterBake).subscribe();
        EventManager.mod(TextureStitchEvent.Pre.class).process(this::transporterTextureStitch).subscribe();
        EventManager.mod(FMLClientSetupEvent.class).process(this::onClientSetupTransporter).subscribe();
    }
}

