/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.entity;

import com.buuz135.industrial.item.infinity.item.ItemInfinityNuke;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.proxy.client.sound.TickeableSound;
import com.buuz135.industrial.utils.explosion.ExplosionTickHandler;
import com.buuz135.industrial.utils.explosion.ProcessExplosion;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class InfinityNukeEntity
extends Entity {
    private static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.m_135353_(InfinityNukeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> EXPLODING = SynchedEntityData.m_135353_(InfinityNukeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ARMED = SynchedEntityData.m_135353_(InfinityNukeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TICKS = SynchedEntityData.m_135353_(InfinityNukeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity placedBy;
    private ItemStack original = new ItemStack((ItemLike)ModuleTool.INFINITY_NUKE.get());
    private boolean exploding = false;
    private boolean armed = false;
    private int radius = 1;
    private int ticksExploding = 1;
    private ProcessExplosion explosionHelper;
    @OnlyIn(value=Dist.CLIENT)
    private TickeableSound chargingSound;
    @OnlyIn(value=Dist.CLIENT)
    private TickeableSound explodingSound;

    public InfinityNukeEntity(EntityType<? extends InfinityNukeEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_19850_ = true;
    }

    public InfinityNukeEntity(Level worldIn, LivingEntity owner, ItemStack original) {
        this((EntityType<? extends InfinityNukeEntity>)((EntityType)ModuleTool.INFINITY_NUKE_ENTITY_TYPE.get()), worldIn);
        this.placedBy = owner;
        this.original = original;
        this.radius = ItemInfinityNuke.getRadius(original);
        this.f_19804_.m_135381_(RADIUS, (Object)this.radius);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        if (this.exploding) {
            if (this.f_19853_ instanceof ServerLevel && this.explosionHelper == null) {
                this.explosionHelper = new ProcessExplosion(this.m_142538_(), ItemInfinityNuke.getRadius(this.original), (ServerLevel)this.f_19853_, 39, this.placedBy != null ? this.placedBy.m_5446_().getString() : "");
                ExplosionTickHandler.processExplosionList.add(this.explosionHelper);
            }
            this.setTicksExploding(this.getTicksExploding() + 1);
            this.m_20073_();
        }
        if (this.f_19853_.f_46443_ && ((Boolean)this.m_20088_().m_135370_(EXPLODING)).booleanValue() && this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 1.1, this.m_20189_(), 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.f_19853_.m_8055_(this.m_142538_().m_7495_())), this.m_20185_() + this.f_19853_.m_5822_().nextDouble() - 0.5, this.m_20186_(), this.m_20189_() + this.f_19853_.m_5822_().nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.explosionHelper != null && this.explosionHelper.isDead) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_142036_();
        }
        if (this.f_19853_.f_46443_) {
            this.tickClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        if (this.chargingSound == null && ((Boolean)this.m_20088_().m_135370_(EXPLODING)).booleanValue()) {
            this.chargingSound = new TickeableSound(this.f_19853_, this.m_142538_(), (SoundEvent)ModuleTool.NUKE_CHARGING.get(), (Integer)this.m_20088_().m_135370_(RADIUS), 10);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.chargingSound);
        }
        if (this.chargingSound != null) {
            this.chargingSound.increase();
            if (!Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)this.chargingSound) && this.explodingSound == null) {
                this.explodingSound = new TickeableSound(this.f_19853_, this.m_142538_(), ClientProxy.NUKE_EXPLOSION, (Integer)this.m_20088_().m_135370_(RADIUS), 10);
                this.explodingSound.setPitch(1.0f);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.explodingSound);
            }
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)1);
        this.f_19804_.m_135372_(EXPLODING, (Object)false);
        this.f_19804_.m_135372_(ARMED, (Object)false);
        this.f_19804_.m_135372_(TICKS, (Object)1);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("Original", (Tag)this.getOriginal().serializeNBT());
        compound.m_128379_("Exploding", this.isExploding());
        compound.m_128379_("Armed", this.isArmed());
        compound.m_128405_("TicksExploding", this.getTicksExploding());
    }

    protected void m_7378_(CompoundTag compound) {
        this.setArmed(compound.m_128471_("Armed"));
        this.setExploding(compound.m_128471_("Exploding"));
        this.setOriginal(ItemStack.m_41712_((CompoundTag)compound.m_128469_("Original")));
        this.setTicksExploding(compound.m_128451_("TicksExploding"));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.isExploding()) {
            return InteractionResult.SUCCESS;
        }
        if (player.f_19853_.f_46443_ && hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41619_()) {
            this.arm();
        }
        if (!player.f_19853_.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            if (player.m_21120_(hand).m_41619_()) {
                if (player.m_6144_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.original);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    this.m_142036_();
                    return InteractionResult.SUCCESS;
                }
                this.setArmed(!this.isArmed());
                return InteractionResult.SUCCESS;
            }
            if (!this.isExploding() && this.isArmed() && player.m_21120_(hand).m_41720_().equals(Items.f_42409_)) {
                this.setExploding(true);
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6096_(player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void arm() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(ClientProxy.NUKE_ARMING, SoundSource.BLOCKS, 1.0f, 1.0f, this.m_142538_()));
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public ItemStack getOriginal() {
        return this.original;
    }

    public void setOriginal(ItemStack original) {
        this.original = original;
    }

    public boolean isExploding() {
        return this.exploding;
    }

    public void setExploding(boolean exploding) {
        this.exploding = exploding;
        this.m_20088_().m_135381_(EXPLODING, (Object)exploding);
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean armed) {
        this.armed = armed;
        this.m_20088_().m_135381_(ARMED, (Object)armed);
    }

    public boolean isDataArmed() {
        return (Boolean)this.m_20088_().m_135370_(ARMED);
    }

    public boolean isDataExploding() {
        return (Boolean)this.m_20088_().m_135370_(EXPLODING);
    }

    public int getTicksExploding() {
        return this.ticksExploding;
    }

    public void setTicksExploding(int ticksExploding) {
        this.ticksExploding = ticksExploding;
        this.m_20088_().m_135381_(TICKS, (Object)ticksExploding);
    }

    public int getDataTicksExploding() {
        return (Integer)this.m_20088_().m_135370_(TICKS);
    }
}

