/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.tile;

import com.buuz135.industrial.block.transportstorage.tile.BHTile;
import com.buuz135.industrial.capability.tile.BigSidedFluidTankComponent;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.NumberUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.filter.FilterSlot;
import com.hrznstudio.titanium.api.filter.IFilter;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.filter.ItemStackFilter;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class BlackHoleTankTile
extends BHTile<BlackHoleTankTile> {
    @Save
    public BigSidedFluidTankComponent<BlackHoleTankTile> tank;
    @Save
    private ItemStackFilter filter;
    private boolean isEmpty;

    public BlackHoleTankTile(BasicTileBlock<BlackHoleTankTile> base, BlockEntityType<?> type, Rarity rarity, BlockPos blockPos, BlockState blockState) {
        super(base, type, blockPos, blockState);
        this.tank = (BigSidedFluidTankComponent)new BigSidedFluidTankComponent<BlackHoleTankTile>("tank", BlockUtils.getFluidAmountByRarity(rarity), 20, 20, 0){

            @Override
            public void sync() {
                BlackHoleTankTile.this.syncObject(BlackHoleTankTile.this.tank);
            }
        }.setColor(DyeColor.BLUE).setValidator(fluidStack -> ((ItemStack)this.filter.getFilterSlots()[0].getFilter()).m_41619_() ? true : ((ItemStack)this.filter.getFilterSlots()[0].getFilter()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(iFluidHandlerItem -> iFluidHandlerItem.getFluidInTank(0).isFluidEqual(fluidStack)).orElse(false));
        this.addTank((FluidTankComponent)this.tank);
        this.filter = new ItemStackFilter("filter", 1);
        this.addFilter((IFilter)this.filter);
        FilterSlot slot = new FilterSlot(79, 60, 0, (Object)ItemStack.f_41583_);
        slot.setColor(DyeColor.CYAN);
        this.filter.setFilter(0, slot);
        this.isEmpty = true;
    }

    public void clientTick(Level level, BlockPos pos, BlockState state, BlackHoleTankTile blockEntity) {
        super.clientTick(level, pos, state, (BlockEntity)blockEntity);
        if (this.isEmpty != (this.tank.getFluidAmount() == 0)) {
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        this.isEmpty = this.tank.getFluidAmount() == 0;
    }

    public InteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        this.openGui(playerIn);
        return InteractionResult.SUCCESS;
    }

    @Override
    public ItemStack getDisplayStack() {
        ItemStack filledBucket;
        if (this.tank.getFluidAmount() > 0 && !(filledBucket = FluidUtil.getFilledBucket((FluidStack)this.tank.getFluid())).m_41619_()) {
            return filledBucket;
        }
        return new ItemStack((ItemLike)Items.f_42446_);
    }

    @Override
    public String getFormatedDisplayAmount() {
        return NumberUtils.getFormatedBigNumber(this.tank.getFluidAmount() / 1000) + " b";
    }

    @Nonnull
    public BlackHoleTankTile getSelf() {
        return this;
    }

    public SidedFluidTankComponent<BlackHoleTankTile> getTank() {
        return this.tank;
    }
}

