/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.core.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.core.DissolutionChamberConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.bundle.LockableInventoryBundle;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DissolutionChamberTile
extends IndustrialProcessingTile<DissolutionChamberTile> {
    private int maxProgress;
    private int powerPerTick;
    @Save
    private LockableInventoryBundle<DissolutionChamberTile> input;
    @Save
    private SidedFluidTankComponent<DissolutionChamberTile> inputFluid;
    @Save
    private SidedInventoryComponent<DissolutionChamberTile> output;
    @Save
    private SidedFluidTankComponent<DissolutionChamberTile> outputFluid;
    private DissolutionChamberRecipe currentRecipe;

    public DissolutionChamberTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleCore.DISSOLUTION_CHAMBER, 102, 41, blockPos, blockState);
        int slotSpacing = 22;
        this.input = new LockableInventoryBundle((BasicTile)this, new SidedInventoryComponent("input", 34, 19, 8, 0).setColor(DyeColor.LIGHT_BLUE).setSlotPosition(integer -> DissolutionChamberTile.getSlotPos(integer)).setSlotLimit(1).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this).setInputFilter((stack, integer) -> !this.canIncrease()).setOnSlotChanged((stack, integer) -> this.checkForRecipe()), 100, 64, false);
        this.addBundle((IComponentBundle)this.input);
        this.inputFluid = (SidedFluidTankComponent)new SidedFluidTankComponent("input_fluid", DissolutionChamberConfig.maxInputTankSize, 33 + slotSpacing, 18 + slotSpacing, 1).setColor(DyeColor.LIME).setTankType(FluidTankComponent.Type.SMALL).setComponentHarness((IComponentHarness)this).setOnContentChange(() -> this.checkForRecipe());
        this.addTank(this.inputFluid);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 129, 22, 3, 2).setColor(DyeColor.ORANGE).setRange(1, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.outputFluid = (SidedFluidTankComponent)new SidedFluidTankComponent("output_fluid", DissolutionChamberConfig.maxOutputTankSize, 149, 20, 3).setColor(DyeColor.MAGENTA).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.DRAIN);
        this.addTank(this.outputFluid);
        this.maxProgress = DissolutionChamberConfig.maxProgress;
        this.powerPerTick = DissolutionChamberConfig.powerPerTick;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            if (this.currentRecipe != null && this.currentRecipe.matches((IItemHandler)this.input.getInventory(), (FluidTankComponent)this.inputFluid)) {
                return;
            }
            this.currentRecipe = RecipeUtil.getRecipes((Level)this.f_58857_, (RecipeType)DissolutionChamberRecipe.SERIALIZER.getRecipeType()).stream().filter(dissolutionChamberRecipe -> dissolutionChamberRecipe.matches((IItemHandler)this.input.getInventory(), (FluidTankComponent)this.inputFluid)).findFirst().orElse(null);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.checkForRecipe();
    }

    @Override
    public boolean canIncrease() {
        return this.currentRecipe != null && ItemHandlerHelper.insertItem(this.output, (ItemStack)this.currentRecipe.output.m_41777_(), (boolean)true).m_41619_() && (this.currentRecipe.outputFluid == null || this.outputFluid.fillForced(this.currentRecipe.outputFluid.copy(), IFluidHandler.FluidAction.SIMULATE) == this.currentRecipe.outputFluid.getAmount());
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            if (this.currentRecipe != null) {
                DissolutionChamberRecipe dissolutionChamberRecipe = this.currentRecipe;
                this.inputFluid.drainForced(dissolutionChamberRecipe.inputFluid, IFluidHandler.FluidAction.EXECUTE);
                for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
                    this.input.getInventory().getStackInSlot(i).m_41774_(1);
                }
                if (dissolutionChamberRecipe.outputFluid != null && !dissolutionChamberRecipe.outputFluid.isEmpty()) {
                    this.outputFluid.fillForced(dissolutionChamberRecipe.outputFluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                }
                ItemStack outputStack = dissolutionChamberRecipe.output.m_41777_();
                outputStack.m_41720_().m_7836_(outputStack, this.f_58857_, null);
                ItemHandlerHelper.insertItem(this.output, (ItemStack)outputStack, (boolean)false);
                this.checkForRecipe();
            }
        };
    }

    protected EnergyStorageComponent<DissolutionChamberTile> createEnergyStorage() {
        return new EnergyStorageComponent(DissolutionChamberConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return this.powerPerTick;
    }

    @Override
    public int getMaxProgress() {
        return this.currentRecipe != null ? this.currentRecipe.processingTime : this.maxProgress;
    }

    public static Pair<Integer, Integer> getSlotPos(int slot) {
        int slotSpacing = 22;
        int offset = 2;
        switch (slot) {
            case 1: {
                return Pair.of((Object)slotSpacing, (Object)(-offset));
            }
            case 2: {
                return Pair.of((Object)(slotSpacing * 2), (Object)0);
            }
            case 3: {
                return Pair.of((Object)(-offset), (Object)slotSpacing);
            }
            case 4: {
                return Pair.of((Object)(slotSpacing * 2 + offset), (Object)slotSpacing);
            }
            case 5: {
                return Pair.of((Object)0, (Object)(slotSpacing * 2));
            }
            case 6: {
                return Pair.of((Object)slotSpacing, (Object)(slotSpacing * 2 + offset));
            }
            case 7: {
                return Pair.of((Object)(slotSpacing * 2), (Object)(slotSpacing * 2));
            }
        }
        return Pair.of((Object)0, (Object)0);
    }

    @Nonnull
    public DissolutionChamberTile getSelf() {
        return this;
    }
}

