/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.block.agriculturehusbandry.tile.HydroponicBedTile;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.PlantGathererConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PlantGathererTile
extends IndustrialAreaWorkingTile<PlantGathererTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedInventoryComponent<PlantGathererTile> output = (SidedInventoryComponent)new SidedInventoryComponent("output", 78, 22, 15, 0).setColor(DyeColor.ORANGE).setRange(5, 3).setComponentHarness((IComponentHarness)this);
    @Save
    private SidedFluidTankComponent<PlantGathererTile> tank;
    @Save
    private SidedFluidTankComponent<PlantGathererTile> ether;
    @Save
    private ProgressBarComponent<PlantGathererTile> etherBar;

    public PlantGathererTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.PLANT_GATHERER, RangeManager.RangeType.BEHIND, true, PlantGathererConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.output);
        this.tank = (SidedFluidTankComponent)new SidedFluidTankComponent("sludge", PlantGathererConfig.maxSludgeTankSize, 43, 20, 1).setColor(DyeColor.MAGENTA).setTankAction(FluidTankComponent.Action.DRAIN).setTankType(FluidTankComponent.Type.SMALL).setComponentHarness((IComponentHarness)this);
        this.addTank(this.tank);
        this.ether = (SidedFluidTankComponent)new SidedFluidTankComponent("ether", PlantGathererConfig.maxEtherTankSize, 43, 57, 2).setColor(DyeColor.CYAN).setTankAction(FluidTankComponent.Action.FILL).setTankType(FluidTankComponent.Type.SMALL).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)ModuleCore.ETHER.getSourceFluid().get()));
        this.addTank(this.ether);
        this.etherBar = new ProgressBarComponent(63, 20, 0, 100).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN).setCanReset(hydroponicBedTile -> false);
        this.addProgressBar(this.etherBar);
        this.maxProgress = PlantGathererConfig.maxProgress;
        this.powerPerOperation = PlantGathererConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.etherBar.getProgress() == 0 && this.ether.getFluidAmount() > 0) {
            this.etherBar.setProgress(this.etherBar.getMaxProgress());
            this.ether.drainForced(1, IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.hasEnergy(this.powerPerOperation)) {
            int amount = Math.max(1, BlockUtils.getBlockPosInAABB(this.getWorkingArea().m_83215_()).size() / 30);
            for (int i = 0; i < amount; ++i) {
                BlockPos pointed = this.getPointedBlockPos();
                if (this.isLoaded(pointed) && !ItemStackUtils.isInventoryFull(this.output)) {
                    if (this.etherBar.getProgress() > 0) {
                        if (HydroponicBedTile.tryToHarvestAndReplant(this.f_58857_, pointed, this.f_58857_.m_8055_(pointed), this.output, this.etherBar, this)) {
                            return new IndustrialWorkingTile.WorkAction(this, 0.3f, this.powerPerOperation);
                        }
                    } else {
                        Optional<PlantRecollectable> optional = IFRegistries.PLANT_RECOLLECTABLES_REGISTRY.get().getValues().stream().filter(plantRecollectable -> plantRecollectable.canBeHarvested(this.f_58857_, pointed, this.f_58857_.m_8055_(pointed))).findFirst();
                        if (optional.isPresent()) {
                            List<ItemStack> drops = optional.get().doHarvestOperation(this.f_58857_, pointed, this.f_58857_.m_8055_(pointed));
                            this.tank.fill(new FluidStack((Fluid)ModuleCore.SLUDGE.getSourceFluid().get(), 10 * drops.size()), IFluidHandler.FluidAction.EXECUTE);
                            drops.forEach(stack -> ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false));
                            if (optional.get().shouldCheckNextPlant(this.f_58857_, pointed, this.f_58857_.m_8055_(pointed))) {
                                this.increasePointer();
                            }
                            return new IndustrialWorkingTile.WorkAction(this, 0.3f, this.powerPerOperation);
                        }
                    }
                }
                this.increasePointer();
            }
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<PlantGathererTile> createEnergyStorage() {
        return new EnergyStorageComponent(PlantGathererConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public PlantGathererTile getSelf() {
        return this;
    }
}

