/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.agriculturehusbandry.AnimalFeederConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;

public class AnimalFeederTile
extends IndustrialAreaWorkingTile<AnimalFeederTile> {
    private int maxProgress;
    private int powerPerOperation;
    @Save
    private SidedInventoryComponent<AnimalFeederTile> input = (SidedInventoryComponent)new SidedInventoryComponent("food", 53, 22, 18, 0).setColor(DyeColor.BLUE).setOutputFilter((stack, integer) -> false).setRange(6, 3).setComponentHarness((IComponentHarness)this);

    public AnimalFeederTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.ANIMAL_FEEDER, RangeManager.RangeType.BEHIND, true, AnimalFeederConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.input);
        this.maxProgress = AnimalFeederConfig.maxProgress;
        this.powerPerOperation = AnimalFeederConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.hasEnergy(this.powerPerOperation)) {
            List mobs = this.f_58857_.m_45976_(Animal.class, this.getWorkingArea().m_83215_());
            if (mobs.size() == 0 || mobs.size() > 35) {
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
            }
            mobs.removeIf(animalEntity -> animalEntity.m_146764_() != 0 || !animalEntity.m_5957_() || this.getFeedingItem((Animal)animalEntity).m_41619_());
            for (Animal firstParent : mobs) {
                for (Animal secondParent : mobs) {
                    if (firstParent.equals((Object)secondParent) || !firstParent.getClass().equals(secondParent.getClass())) continue;
                    ItemStack stack = this.getFeedingItem(firstParent);
                    ItemStack original = stack.m_41777_();
                    stack.m_41774_(1);
                    stack = this.getFeedingItem(secondParent);
                    if (stack.m_41619_()) {
                        original.m_41764_(1);
                        ItemHandlerHelper.insertItem(this.input, (ItemStack)original, (boolean)false);
                        continue;
                    }
                    stack.m_41774_(1);
                    firstParent.m_27595_(null);
                    secondParent.m_27595_(null);
                    return new IndustrialWorkingTile.WorkAction(this, 0.5f, this.powerPerOperation);
                }
            }
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    private ItemStack getFeedingItem(Animal entity) {
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (!entity.m_6898_(this.input.getStackInSlot(i))) continue;
            return this.input.getStackInSlot(i);
        }
        return ItemStack.f_41583_;
    }

    protected EnergyStorageComponent<AnimalFeederTile> createEnergyStorage() {
        return new EnergyStorageComponent(AnimalFeederConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public AnimalFeederTile getSelf() {
        return this;
    }
}

