/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial;

import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleGenerator;
import com.buuz135.industrial.module.ModuleMisc;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.proxy.client.render.TransporterTESR;
import com.buuz135.industrial.proxy.network.BackpackOpenMessage;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.buuz135.industrial.proxy.network.BackpackSyncMessage;
import com.buuz135.industrial.proxy.network.ConveyorButtonInteractMessage;
import com.buuz135.industrial.proxy.network.ConveyorSplittingSyncEntityMessage;
import com.buuz135.industrial.proxy.network.PlungerPlayerHitMessage;
import com.buuz135.industrial.proxy.network.SpecialParticleMessage;
import com.buuz135.industrial.proxy.network.TransporterButtonInteractMessage;
import com.buuz135.industrial.proxy.network.TransporterSyncMessage;
import com.buuz135.industrial.recipe.CrusherRecipe;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import com.buuz135.industrial.recipe.LaserDrillFluidRecipe;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.buuz135.industrial.recipe.StoneWorkGenerateRecipe;
import com.buuz135.industrial.recipe.provider.IndustrialRecipeProvider;
import com.buuz135.industrial.recipe.provider.IndustrialSerializableProvider;
import com.buuz135.industrial.recipe.provider.IndustrialTagsProvider;
import com.buuz135.industrial.registry.IFRegistries;
import com.buuz135.industrial.utils.IFFakePlayer;
import com.buuz135.industrial.utils.data.IndustrialBlockstateProvider;
import com.buuz135.industrial.utils.data.IndustrialModelProvider;
import com.hrznstudio.titanium.datagenerator.loot.TitaniumLootTableProvider;
import com.hrznstudio.titanium.datagenerator.model.BlockItemModelGeneratorProvider;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.network.locator.PlayerInventoryFinder;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardGiver;
import com.hrznstudio.titanium.reward.RewardManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="industrialforegoing")
public class IndustrialForegoing
extends ModuleController {
    private static CommonProxy proxy;
    private static HashMap<DimensionType, IFFakePlayer> worldFakePlayer;
    public static NetworkHandler NETWORK;
    public static Logger LOGGER;
    public static IndustrialForegoing INSTANCE;

    public IndustrialForegoing() {
        proxy = new CommonProxy();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> EventManager.mod(FMLClientSetupEvent.class).process(fmlClientSetupEvent -> new ClientProxy().run()).subscribe());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> EventManager.mod(ModelRegistryEvent.class).process(modelRegistryEvent -> ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("industrialforegoing", "block/catears"))).subscribe());
        EventManager.mod(FMLCommonSetupEvent.class).process(fmlCommonSetupEvent -> proxy.run()).subscribe();
        EventManager.forge(ServerStartingEvent.class).process(fmlServerStartingEvent -> worldFakePlayer.clear()).subscribe();
        EventManager.mod(NewRegistryEvent.class).process(IFRegistries::create).subscribe();
        EventManager.modGeneric(RegistryEvent.Register.class, RecipeSerializer.class).process(register -> ((RegistryEvent.Register)register).getRegistry().registerAll(new IForgeRegistryEntry[]{FluidExtractorRecipe.SERIALIZER, DissolutionChamberRecipe.SERIALIZER, LaserDrillOreRecipe.SERIALIZER, LaserDrillFluidRecipe.SERIALIZER, StoneWorkGenerateRecipe.SERIALIZER, CrusherRecipe.SERIALIZER})).subscribe();
        RewardGiver giver = RewardManager.get().getGiver(UUID.fromString("d28b7061-fb92-4064-90fb-7e02b95a72a6"), "Buuz135");
        try {
            giver.addReward(new Reward(new ResourceLocation("industrialforegoing", "cat_ears"), new URL("https://raw.githubusercontent.com/Buuz135/Industrial-Foregoing/master/contributors.json"), () -> dist -> {}, new String[]{"normal", "cat", "spooky", "snowy"}));
        }
        catch (MalformedURLException e) {
            LOGGER.catching((Throwable)e);
        }
        LaserDrillRarity.init();
        PlayerInventoryFinder.init();
        ForgeMod.enableMilkFluid();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::initClient);
    }

    public static FakePlayer getFakePlayer(Level world) {
        if (worldFakePlayer.containsKey(world.m_6042_())) {
            return worldFakePlayer.get(world.m_6042_());
        }
        if (world instanceof ServerLevel) {
            IFFakePlayer fakePlayer = new IFFakePlayer((ServerLevel)world);
            worldFakePlayer.put(world.m_6042_(), fakePlayer);
            return fakePlayer;
        }
        return null;
    }

    public static FakePlayer getFakePlayer(Level world, BlockPos pos) {
        FakePlayer player = IndustrialForegoing.getFakePlayer(world);
        if (player != null) {
            player.m_19890_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 90.0f, 90.0f);
        }
        return player;
    }

    public void onPreInit() {
        super.onPreInit();
    }

    public void addDataProvider(GatherDataEvent event) {
        super.addDataProvider(event);
        NonNullLazy blocksToProcess = NonNullLazy.of(() -> ForgeRegistries.BLOCKS.getValues().stream().filter(basicBlock -> Optional.ofNullable(basicBlock.getRegistryName()).map(ResourceLocation::m_135827_).filter("industrialforegoing"::equalsIgnoreCase).isPresent()).collect(Collectors.toList()));
        event.getGenerator().m_123914_((DataProvider)new IndustrialTagsProvider.Blocks(event.getGenerator(), "industrialforegoing", event.getExistingFileHelper()));
        event.getGenerator().m_123914_((DataProvider)new IndustrialTagsProvider.Items(event.getGenerator(), "industrialforegoing", event.getExistingFileHelper()));
        event.getGenerator().m_123914_((DataProvider)new IndustrialRecipeProvider(event.getGenerator(), (NonNullLazy<List<Block>>)blocksToProcess));
        event.getGenerator().m_123914_((DataProvider)new IndustrialSerializableProvider(event.getGenerator(), "industrialforegoing"));
        event.getGenerator().m_123914_((DataProvider)new TitaniumLootTableProvider(event.getGenerator(), blocksToProcess));
        event.getGenerator().m_123914_((DataProvider)new BlockItemModelGeneratorProvider(event.getGenerator(), "industrialforegoing", blocksToProcess));
        event.getGenerator().m_123914_((DataProvider)new IndustrialBlockstateProvider(event.getGenerator(), event.getExistingFileHelper(), (NonNullLazy<List<Block>>)blocksToProcess));
        event.getGenerator().m_123914_((DataProvider)new IndustrialModelProvider(event.getGenerator(), event.getExistingFileHelper()));
    }

    protected void initModules() {
        INSTANCE = this;
        new ModuleCore().generateFeatures(this.getRegistries());
        new ModuleTool().generateFeatures(this.getRegistries());
        new ModuleTransportStorage().generateFeatures(this.getRegistries());
        new ModuleGenerator().generateFeatures(this.getRegistries());
        new ModuleAgricultureHusbandry().generateFeatures(this.getRegistries());
        new ModuleResourceProduction().generateFeatures(this.getRegistries());
        new ModuleMisc().generateFeatures(this.getRegistries());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initClient() {
        EventManager.mod(TextureStitchEvent.Pre.class).process(pre -> {
            if (pre.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
                pre.addSprite(TransporterTESR.TEXTURE);
            }
        }).subscribe();
        EventManager.mod(ModelBakeEvent.class).process(event -> {
            ClientProxy.ears_baked = (BakedModel)event.getModelRegistry().get(new ResourceLocation("industrialforegoing", "block/catears"));
        }).subscribe();
        EventManager.forgeGeneric(RegistryEvent.Register.class, SoundEvent.class).process(registryEvent -> ((RegistryEvent.Register)registryEvent).getRegistry().registerAll(new IForgeRegistryEntry[]{ClientProxy.NUKE_ARMING, ClientProxy.NUKE_EXPLOSION})).subscribe();
    }

    static {
        worldFakePlayer = new HashMap();
        NETWORK = new NetworkHandler("industrialforegoing");
        LOGGER = LogManager.getLogger((String)"industrialforegoing");
        NETWORK.registerMessage(ConveyorButtonInteractMessage.class);
        NETWORK.registerMessage(ConveyorSplittingSyncEntityMessage.class);
        NETWORK.registerMessage(SpecialParticleMessage.class);
        NETWORK.registerMessage(BackpackSyncMessage.class);
        NETWORK.registerMessage(BackpackOpenMessage.class);
        NETWORK.registerMessage(BackpackOpenedMessage.class);
        NETWORK.registerMessage(TransporterSyncMessage.class);
        NETWORK.registerMessage(TransporterButtonInteractMessage.class);
        NETWORK.registerMessage(PlungerPlayerHitMessage.class);
    }
}

