/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.login;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserType;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.util.UUIDTypeAdapter;
import com.sintinium.oauth.GuiEventHandler;
import com.sintinium.oauth.profile.MicrosoftProfile;
import com.sintinium.oauth.profile.MojangProfile;
import com.sintinium.oauth.util.MultiplayerAllowedUtil;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class LoginUtil {
    public static String lastMojangUsername = null;
    public static boolean needsRefresh = true;
    public static boolean wasOnline = false;
    private static long lastCheck = -1L;
    private static final YggdrasilAuthenticationService authService = new YggdrasilAuthenticationService(Minecraft.m_91087_().m_91096_(), UUID.randomUUID().toString());
    private static final YggdrasilUserAuthentication userAuth = (YggdrasilUserAuthentication)authService.createUserAuthentication(Agent.MINECRAFT);
    private static final YggdrasilMinecraftSessionService minecraftSessionService = (YggdrasilMinecraftSessionService)authService.createMinecraftSessionService();
    private static boolean isMultiplayerDisabled = false;

    public static void updateOnlineStatus() {
        needsRefresh = true;
        LoginUtil.isOnline();
    }

    public static boolean isMultiplayerDisabled() {
        return isMultiplayerDisabled;
    }

    public static boolean isOnline() {
        if (!needsRefresh && System.currentTimeMillis() - lastCheck < 10000L) {
            return wasOnline;
        }
        User session = Minecraft.m_91087_().m_91094_();
        String uuid = UUID.randomUUID().toString();
        needsRefresh = false;
        lastCheck = System.currentTimeMillis();
        GuiEventHandler.warned = false;
        isMultiplayerDisabled = MultiplayerAllowedUtil.isMultiplayerDisabled(session.m_92547_());
        try {
            minecraftSessionService.joinServer(session.m_92548_(), session.m_92547_(), uuid);
            GameProfile mssProfile = minecraftSessionService.hasJoinedServer(session.m_92548_(), uuid, null);
            if (mssProfile != null && mssProfile.isComplete()) {
                wasOnline = true;
                return true;
            }
            wasOnline = false;
            return false;
        }
        catch (AuthenticationException e) {
            wasOnline = false;
            return false;
        }
    }

    public static GameProfile getGameProfile(User session) {
        String serverId = UUID.randomUUID().toString();
        needsRefresh = false;
        lastCheck = System.currentTimeMillis();
        try {
            minecraftSessionService.joinServer(session.m_92548_(), session.m_92547_(), serverId);
            GameProfile profile = minecraftSessionService.hasJoinedServer(session.m_92548_(), serverId, null);
            if (profile != null && profile.isComplete()) {
                return profile;
            }
        }
        catch (AuthenticationException e) {
            return null;
        }
        return null;
    }

    public static void loginMs(MicrosoftProfile profile) throws WrongMinecraftVersionException {
        User session = new User(profile.getName(), profile.getUUID().toString(), profile.getAccessToken(), Optional.empty(), Optional.empty(), User.Type.MSA);
        LoginUtil.setSession(session);
    }

    public static MojangProfile tryGetMojangProfile(String username, String password) throws AuthenticationException {
        if (password.isEmpty()) {
            return null;
        }
        userAuth.setUsername(username);
        userAuth.setPassword(password);
        userAuth.logIn();
        String name = userAuth.getSelectedProfile().getName();
        UUID uuid = userAuth.getSelectedProfile().getId();
        String token = userAuth.getAuthenticatedToken();
        UserType type = userAuth.getUserType();
        boolean isOnline = userAuth.canPlayOnline();
        userAuth.logOut();
        if (!isOnline) {
            return null;
        }
        return new MojangProfile(name, username, password, uuid, type);
    }

    public static void loginOffline(String username) throws WrongMinecraftVersionException {
        User session = new User(username, UUID.nameUUIDFromBytes(username.getBytes()).toString(), "NotValid", Optional.empty(), Optional.empty(), User.Type.LEGACY);
        LoginUtil.setSession(session);
    }

    public static boolean loginMojangOrLegacy(String username, String password) throws AuthenticationException, WrongMinecraftVersionException {
        if (password.isEmpty()) {
            return false;
        }
        userAuth.setUsername(username);
        userAuth.setPassword(password);
        userAuth.logIn();
        String name = userAuth.getSelectedProfile().getName();
        String uuid = UUIDTypeAdapter.fromUUID((UUID)userAuth.getSelectedProfile().getId());
        String token = userAuth.getAuthenticatedToken();
        UserType type = userAuth.getUserType();
        boolean isOnline = userAuth.canPlayOnline();
        userAuth.logOut();
        User session = new User(name, uuid, token, Optional.empty(), Optional.empty(), User.Type.m_92561_((String)type.getName()));
        LoginUtil.setSession(session);
        lastMojangUsername = username;
        return isOnline;
    }

    public static void setSession(User session) throws WrongMinecraftVersionException {
        Field field = ObfuscationReflectionHelper.findField(Minecraft.class, (String)"f_90998_");
        field.setAccessible(true);
        try {
            field.set(Minecraft.m_91087_(), session);
        }
        catch (IllegalAccessException e) {
            throw new WrongMinecraftVersionException("Missing session field. Are you using SRG mappings?");
        }
        needsRefresh = true;
        LoginUtil.updateOnlineStatus();
    }

    public static class WrongMinecraftVersionException
    extends Exception {
        public WrongMinecraftVersionException() {
        }

        public WrongMinecraftVersionException(String message) {
            super(message);
        }

        public WrongMinecraftVersionException(String message, Throwable cause) {
            super(message, cause);
        }

        public WrongMinecraftVersionException(Throwable cause) {
            super(cause);
        }

        public WrongMinecraftVersionException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

