/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui.profile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sintinium.oauth.gui.profile.FakePlayer;
import com.sintinium.oauth.gui.profile.ProfileList;
import com.sintinium.oauth.profile.IProfile;
import com.sintinium.oauth.profile.OfflineProfile;
import com.sintinium.oauth.profile.ProfileManager;
import java.io.IOException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ProfileEntry
extends ObjectSelectionList.Entry<ProfileEntry> {
    private static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/resource_packs.png");
    private final IProfile profile;
    private final ProfileList profileList;
    private final boolean isOffline;
    private final ArrowButton upArrow;
    private final ArrowButton downArrow;
    private long lastClickTime = 0L;

    public ProfileEntry(ProfileList profileList, IProfile profile) {
        this.profileList = profileList;
        this.profile = profile;
        this.isOffline = profile instanceof OfflineProfile;
        this.upArrow = new ArrowButton(-31, 2, 114.0f, 5.0f);
        this.downArrow = new ArrowButton(-18, 2, 82.0f, 20.0f);
    }

    public IProfile getProfile() {
        return this.profile;
    }

    public boolean isOffline() {
        return this.isOffline;
    }

    public void m_6311_(PoseStack pMatrixStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTicks) {
        Object name = this.profile.getName();
        if (this.isOffline) {
            name = (String)name + " (Offline)";
        }
        Minecraft.m_91087_().f_91062_.m_92750_(pMatrixStack, (String)name, (float)pLeft, (float)(pTop + 2), 0xFFFFFF);
        if (this.profileList.m_93511_() == this) {
            this.upArrow.setSelected(true);
            this.downArrow.setSelected(true);
        } else {
            this.upArrow.setSelected(false);
            this.downArrow.setSelected(false);
        }
        if (!pIsMouseOver) {
            return;
        }
        this.upArrow.setPosition(pLeft + pWidth, pTop);
        this.downArrow.setPosition(pLeft + pWidth, pTop);
        if (this.profileList.m_6702_().indexOf((Object)this) > 0) {
            this.upArrow.render(pMatrixStack, pIndex, pTop, pLeft, pWidth, pHeight, pMouseX, pMouseY, pIsMouseOver, pPartialTicks);
        }
        if (this.profileList.m_6702_().indexOf((Object)this) < this.profileList.m_6702_().size() - 1) {
            this.downArrow.render(pMatrixStack, pIndex, pTop, pLeft, pWidth, pHeight, pMouseX, pMouseY, pIsMouseOver, pPartialTicks);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        int i = this.profileList.m_6702_().indexOf((Object)this);
        if (i > 0 && this.upArrow.isMouseOver((int)x, (int)y)) {
            this.movePosition(-1);
            return true;
        }
        if (i < this.profileList.m_6702_().size() - 1 && this.downArrow.isMouseOver((int)x, (int)y)) {
            this.movePosition(1);
            return true;
        }
        this.profileList.setSelected(this);
        if (Util.m_137550_() - this.lastClickTime < 250L) {
            this.profileList.getProfileSelectionScreen().onLoginButton(this);
        }
        this.lastClickTime = Util.m_137550_();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePosition(int offset) {
        ProfileManager pm = ProfileManager.getInstance();
        try {
            int i = pm.getProfiles().indexOf(this.profile);
            pm.getProfiles().remove(i);
            pm.getProfiles().add(i + offset, this.profile);
            ProfileManager.getInstance().save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.profileList.loadProfiles(this.profile.getUUID());
        }
    }

    public void onSelected() {
        if (this.isOffline) {
            FakePlayer.getInstance().setSkin(null);
            return;
        }
        FakePlayer.getInstance().setSkin(this.profile.getGameProfile());
    }

    @NotNull
    public Component m_142172_() {
        return new TextComponent("");
    }

    private static class ArrowButton {
        private final int xOffset;
        private final int yOffset;
        private int x;
        private int y;
        private final int width = 11;
        private final int height = 7;
        private boolean isSelected = false;
        private final float textureX;
        private final float textureY;

        public ArrowButton(int xOffset, int yOffset, float textureX, float textureY) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.textureX = textureX;
            this.textureY = textureY;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public void setPosition(int x, int y) {
            this.x = x + this.xOffset;
            this.y = y + this.yOffset;
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + 11 && mouseY >= this.y && mouseY <= this.y + 7;
        }

        public void render(PoseStack pMatrixStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTicks) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_OVERLAY_LOCATION);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.isMouseOver(pMouseX, pMouseY)) {
                GuiComponent.m_93133_((PoseStack)pMatrixStack, (int)this.x, (int)this.y, (float)this.textureX, (float)(this.textureY + 32.0f), (int)11, (int)7, (int)256, (int)256);
            } else {
                GuiComponent.m_93133_((PoseStack)pMatrixStack, (int)this.x, (int)this.y, (float)this.textureX, (float)this.textureY, (int)11, (int)7, (int)256, (int)256);
            }
        }
    }
}

