/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sintinium.oauth.gui.ErrorScreen;
import com.sintinium.oauth.gui.OAuthScreen;
import com.sintinium.oauth.gui.ResponsiveButton;
import com.sintinium.oauth.gui.components.PasswordBox;
import com.sintinium.oauth.gui.profile.ProfileSelectionScreen;
import com.sintinium.oauth.login.LoginUtil;
import com.sintinium.oauth.profile.MojangProfile;
import com.sintinium.oauth.profile.OfflineProfile;
import com.sintinium.oauth.profile.ProfileManager;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class LoginScreen
extends OAuthScreen {
    private Button mojangLoginButton;
    private EditBox passwordWidget;
    private EditBox usernameWidget;
    private final AtomicReference<String> status = new AtomicReference();
    private final List<Runnable> toRun = new CopyOnWriteArrayList<Runnable>();

    public LoginScreen() {
        super((Component)new TextComponent("OAuth Login"));
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
        this.usernameWidget.m_94120_();
        this.passwordWidget.m_94120_();
        if (this.usernameWidget.m_93696_()) {
            this.passwordWidget.m_94178_(false);
        }
        if (this.passwordWidget.m_93696_()) {
            this.usernameWidget.m_94178_(false);
        }
        if (!this.toRun.isEmpty()) {
            for (Runnable r : this.toRun) {
                r.run();
            }
            this.toRun.clear();
        }
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        this.usernameWidget = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 60, 200, 20, (Component)new TextComponent("Username/Email"));
        this.usernameWidget.m_94151_(this::onEdited);
        this.m_94718_((GuiEventListener)this.usernameWidget);
        this.passwordWidget = new PasswordBox(this.f_96547_, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 20, 200, 20, (Component)new TextComponent("Password"));
        this.passwordWidget.m_94199_(128);
        this.passwordWidget.m_94151_(this::onEdited);
        this.m_7787_((GuiEventListener)this.usernameWidget);
        this.m_7787_((GuiEventListener)this.passwordWidget);
        this.mojangLoginButton = (Button)this.m_142416_((GuiEventListener)new ResponsiveButton(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 36, 200, 20, (Component)new TextComponent("Add Profile"), p_213030_1_ -> {
            Thread thread = new Thread(() -> {
                if (this.usernameWidget.m_94155_().isEmpty()) {
                    this.toRun.add(() -> this.status.set("Missing username!"));
                } else {
                    MojangProfile profile;
                    if (this.passwordWidget.m_94155_().isEmpty()) {
                        ProfileManager.getInstance().addProfile(new OfflineProfile(this.usernameWidget.m_94155_(), UUID.nameUUIDFromBytes(this.usernameWidget.m_94155_().getBytes())));
                        this.toRun.add(() -> LoginScreen.setScreen(new ProfileSelectionScreen()));
                        return;
                    }
                    try {
                        profile = LoginUtil.tryGetMojangProfile(this.usernameWidget.m_94155_(), this.passwordWidget.m_94155_());
                    }
                    catch (InvalidCredentialsException e) {
                        this.toRun.add(() -> this.status.set("Invalid username or password!"));
                        return;
                    }
                    catch (AuthenticationUnavailableException e) {
                        this.toRun.add(() -> this.status.set("You seem to be offline. Check your connection!"));
                        e.printStackTrace();
                        return;
                    }
                    catch (AuthenticationException e) {
                        this.toRun.add(() -> LoginScreen.setScreen(new ErrorScreen(false, e)));
                        e.printStackTrace();
                        return;
                    }
                    if (profile == null) {
                        this.toRun.add(() -> this.status.set("Invalid username or password!"));
                    } else {
                        LoginUtil.updateOnlineStatus();
                        ProfileManager.getInstance().addProfile(profile);
                        this.toRun.add(() -> LoginScreen.setScreen(new ProfileSelectionScreen()));
                    }
                }
            }, "Oauth mojang");
            thread.setDaemon(true);
            thread.start();
        }, this::updateLoginButton, () -> this.mojangLoginButton.m_93666_((Component)new TextComponent("Add Profile"))));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 60, 200, 20, CommonComponents.f_130656_, p_213029_1_ -> LoginScreen.setScreen(new ProfileSelectionScreen())));
        this.cleanUp();
    }

    public void m_6574_(Minecraft p_231152_1_, int p_231152_2_, int p_231152_3_) {
        String s = this.passwordWidget.m_94155_();
        String s1 = this.usernameWidget.m_94155_();
        this.m_6575_(p_231152_1_, p_231152_2_, p_231152_3_);
        this.passwordWidget.m_94144_(s);
        this.usernameWidget.m_94144_(s1);
    }

    private void onEdited(String p_213028_1_) {
        this.cleanUp();
    }

    private void updateLoginButton() {
        if (this.passwordWidget.m_94155_().isEmpty()) {
            this.mojangLoginButton.m_93666_((Component)new TextComponent("Add Offline Profile"));
        } else {
            this.mojangLoginButton.m_93666_((Component)new TextComponent("Add Profile"));
        }
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_7379_() {
        this.cleanUp();
        this.f_96541_.m_91152_((Screen)new ProfileSelectionScreen());
    }

    private void cleanUp() {
        this.mojangLoginButton.f_93623_ = !this.usernameWidget.m_94155_().isEmpty();
    }

    public void m_6305_(PoseStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_7333_(p_230430_1_);
        LoginScreen.m_93215_((PoseStack)p_230430_1_, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)17, (int)0xFFFFFF);
        LoginScreen.m_93236_((PoseStack)p_230430_1_, (Font)this.f_96547_, (String)"Username/Email", (int)(this.f_96543_ / 2 - 100), (int)(this.f_96544_ / 2 - 60 - 12), (int)0xA0A0A0);
        LoginScreen.m_93236_((PoseStack)p_230430_1_, (Font)this.f_96547_, (String)"Password", (int)(this.f_96543_ / 2 - 100), (int)(this.f_96544_ / 2 - 20 - 12), (int)0xA0A0A0);
        if (this.status.get() != null) {
            LoginScreen.m_93208_((PoseStack)p_230430_1_, (Font)Minecraft.m_91087_().f_91062_, (String)this.status.get(), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 + 20), (int)0xFF0000);
        }
        this.usernameWidget.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        this.passwordWidget.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        super.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

