/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.gui;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sintinium.oauth.OAuth;
import com.sintinium.oauth.gui.OAuthScreen;
import com.sintinium.oauth.login.MicrosoftLogin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ErrorScreen
extends OAuthScreen {
    private String message = null;
    private Throwable e = null;
    private boolean isInfo = false;

    public ErrorScreen(boolean isMs, String message) {
        super((Component)new TextComponent("Error logging into " + (isMs ? "Microsoft." : "Mojang.")));
        this.message = message;
        System.err.println(message);
    }

    public ErrorScreen(boolean isMs, Throwable e) {
        super((Component)new TextComponent("Error logging into " + (isMs ? "Microsoft." : "Mojang.")));
        this.e = e;
        e.printStackTrace();
    }

    public void setInfo() {
        this.isInfo = true;
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 60, 200, 20, CommonComponents.f_130656_, p_onPress_1_ -> ErrorScreen.setScreen((Screen)new JoinMultiplayerScreen((Screen)new TitleScreen()))));
    }

    @Override
    public void m_96624_() {
        super.m_96624_();
    }

    public static ErrorScreen microsoftExceptionScreen(MicrosoftLogin.BaseMicrosoftLoginException e) {
        ErrorScreen screen = null;
        if (e instanceof MicrosoftLogin.NoXboxAccountException) {
            screen = new ErrorScreen(true, "This account has no Microsoft/Xbox account. Please login through minecraft.net to create one.");
        } else if (e instanceof MicrosoftLogin.BannedCountryException) {
            screen = new ErrorScreen(true, "This account is from a country where Xbox Live is not available/banned.");
        } else if (e instanceof MicrosoftLogin.UnderageAccountException) {
            screen = new ErrorScreen(true, "This account is under 18 and doesn't work with 3rd party logins.\nEither change your account's age or have an adult setup a family group.");
        } else if (e instanceof MicrosoftLogin.NoAccountFoundException) {
            screen = new ErrorScreen(true, "This account doesn't own Minecraft.\nIf you're a gamepass user make sure to login through the new launcher first.");
        } else {
            throw new IllegalStateException("Unknown MicrosoftLoginException: " + e.getClass().getName());
        }
        screen.setInfo();
        return screen;
    }

    private String getMessage() {
        String result = "";
        if (this.message != null) {
            result = this.message;
        } else if (this.e != null) {
            result = ExceptionUtils.getStackTrace((Throwable)this.e);
        } else {
            return "Error getting error message.";
        }
        return result;
    }

    public void m_6305_(PoseStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        Font font = Minecraft.m_91087_().f_91062_;
        this.m_7333_(p_230430_1_);
        if (this.isInfo) {
            ErrorScreen.m_93215_((PoseStack)p_230430_1_, (Font)Minecraft.m_91087_().f_91062_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 40), (int)0xFFFFFF);
            Iterable messages = Splitter.on((String)"\n").split((CharSequence)this.getMessage());
            int index = 0;
            for (String m : messages) {
                font.m_92750_(p_230430_1_, m, (float)this.f_96543_ / 2.0f - (float)font.m_92895_(m) / 2.0f, (float)this.f_96544_ / 2.0f - 24.0f + (float)index * 12.0f, 0xFF4444);
                ++index;
            }
        } else if (this.getMessage().toLowerCase().contains("no such host is known") || this.getMessage().toLowerCase().contains("connection reset")) {
            ErrorScreen.m_93215_((PoseStack)p_230430_1_, (Font)Minecraft.m_91087_().f_91062_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 40), (int)0xFFFFFF);
            ErrorScreen.m_93208_((PoseStack)p_230430_1_, (Font)Minecraft.m_91087_().f_91062_, (String)"The servers could be down or it could be an internet problem.", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 28), (int)0xFFFFFF);
            ErrorScreen.m_93208_((PoseStack)p_230430_1_, (Font)Minecraft.m_91087_().f_91062_, (String)"If you believe this is a bug please create an issue at", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 12), (int)0xFFFFFF);
            ErrorScreen.m_93208_((PoseStack)p_230430_1_, (Font)Minecraft.m_91087_().f_91062_, (String)"https://github.com/Sintinium/oauth with your latest log file.", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)0xFFFFFF);
        } else {
            MutableComponent github = new TextComponent("Please create an issue at https://github.com/Sintinium/oauth with your log file.").m_6270_(Style.f_131099_.setUnderlined(Boolean.valueOf(true)));
            ErrorScreen.m_93208_((PoseStack)p_230430_1_, (Font)Minecraft.m_91087_().f_91062_, (String)"An error occurred. This could be a bug.", (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 40), (int)0xFFFFFF);
            ErrorScreen.m_93215_((PoseStack)p_230430_1_, (Font)Minecraft.m_91087_().f_91062_, (Component)github, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 28), (int)0xFFFFFF);
            float scale = 0.5f;
            p_230430_1_.m_85841_(scale, scale, scale);
            Object msg = this.getMessage();
            if (OAuth.getInstance().modContainer != null) {
                msg = "OAuth Forge v" + OAuth.getInstance().modContainer.getModInfo().getVersion().toString() + ": " + (String)msg;
            }
            Iterable messages = Splitter.fixedLength((int)Math.round(80.0f * (1.0f / scale))).limit(12).split((CharSequence)msg);
            int index = 0;
            for (String m : messages) {
                font.m_92750_(p_230430_1_, m, (float)this.f_96543_ / 2.0f - (float)font.m_92895_(m) / 2.0f * scale, ((float)this.f_96544_ / 2.0f - 16.0f) * (1.0f / scale) + (float)index * 12.0f, 0xFF4444);
                ++index;
            }
            p_230430_1_.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
        }
        super.m_6305_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

