/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network.to_server;

import java.util.function.BiFunction;
import mekanism.api.text.ILangEntry;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class PacketGeneratorsGuiButtonPress
implements IMekanismPacket {
    private final ClickedGeneratorsTileButton tileButton;
    private final int extra;
    private final BlockPos tilePosition;

    public PacketGeneratorsGuiButtonPress(ClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition) {
        this(buttonClicked, tilePosition, 0);
    }

    public PacketGeneratorsGuiButtonPress(ClickedGeneratorsTileButton buttonClicked, BlockPos tilePosition, int extra) {
        this.tileButton = buttonClicked;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        MenuProvider provider;
        TileEntityMekanism tile;
        ServerPlayer player = context.getSender();
        if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.f_19853_, (BlockPos)this.tilePosition)) != null && (provider = this.tileButton.getProvider(tile, this.extra)) != null) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)provider, buf -> {
                buf.m_130064_(this.tilePosition);
                buf.m_130130_(this.extra);
            });
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.tileButton);
        buffer.m_130064_(this.tilePosition);
        buffer.m_130130_(this.extra);
    }

    public static PacketGeneratorsGuiButtonPress decode(FriendlyByteBuf buffer) {
        return new PacketGeneratorsGuiButtonPress((ClickedGeneratorsTileButton)buffer.m_130066_(ClickedGeneratorsTileButton.class), buffer.m_130135_(), buffer.m_130242_());
    }

    public static enum ClickedGeneratorsTileButton {
        TAB_MAIN((tile, extra) -> {
            if (tile instanceof TileEntityTurbineCasing) {
                return GeneratorsContainerTypes.INDUSTRIAL_TURBINE.getProvider((ILangEntry)GeneratorsLang.TURBINE, tile);
            }
            if (tile instanceof TileEntityFissionReactorCasing) {
                return GeneratorsContainerTypes.FISSION_REACTOR.getProvider((ILangEntry)GeneratorsLang.FISSION_REACTOR, tile);
            }
            return null;
        }),
        TAB_HEAT((tile, extra) -> GeneratorsContainerTypes.FUSION_REACTOR_HEAT.getProvider((ILangEntry)GeneratorsLang.FUSION_REACTOR, tile)),
        TAB_FUEL((tile, extra) -> GeneratorsContainerTypes.FUSION_REACTOR_FUEL.getProvider((ILangEntry)GeneratorsLang.FUSION_REACTOR, tile)),
        TAB_STATS((tile, extra) -> {
            if (tile instanceof TileEntityTurbineCasing) {
                return GeneratorsContainerTypes.TURBINE_STATS.getProvider((ILangEntry)GeneratorsLang.TURBINE_STATS, tile);
            }
            if (tile instanceof TileEntityFusionReactorController) {
                return GeneratorsContainerTypes.FUSION_REACTOR_STATS.getProvider((ILangEntry)GeneratorsLang.FUSION_REACTOR, tile);
            }
            if (tile instanceof TileEntityFissionReactorCasing) {
                return GeneratorsContainerTypes.FISSION_REACTOR_STATS.getProvider((ILangEntry)GeneratorsLang.FISSION_REACTOR_STATS, tile);
            }
            return null;
        });

        private final BiFunction<TileEntityMekanism, Integer, MenuProvider> providerFromTile;

        private ClickedGeneratorsTileButton(BiFunction<TileEntityMekanism, Integer, MenuProvider> providerFromTile) {
            this.providerFromTile = providerFromTile;
        }

        public MenuProvider getProvider(TileEntityMekanism tile, int extra) {
            return this.providerFromTile.apply(tile, extra);
        }
    }
}

