/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element.button;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class ReactorLogicButton<TYPE extends Enum<TYPE>>
extends MekanismButton {
    private static final ResourceLocation TEXTURE = MekanismGenerators.rl(MekanismUtils.ResourceType.GUI_BUTTON.getPrefix() + "reactor_logic.png");
    @Nonnull
    private final IReactorLogic<TYPE> tile;
    private final int index;
    private final IntSupplier indexSupplier;
    private final Supplier<TYPE[]> modeList;
    private final Consumer<TYPE> onPress;

    public ReactorLogicButton(IGuiWrapper gui, int x, int y, int index, @Nonnull IReactorLogic<TYPE> tile, IntSupplier indexSupplier, Supplier<TYPE[]> listSupplier, Consumer<TYPE> onPress) {
        super(gui, x, y, 128, 22, TextComponent.f_131282_, null, null);
        this.index = index;
        this.indexSupplier = indexSupplier;
        this.modeList = listSupplier;
        this.tile = tile;
        this.onPress = onPress;
    }

    public void m_5716_(double mouseX, double mouseY) {
        TYPE mode = this.getMode();
        if (mode != null) {
            this.onPress.accept(mode);
        }
    }

    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        TYPE mode = this.getMode();
        if (mode != null) {
            this.displayTooltips(matrix, mouseX, mouseY, new Component[]{((IReactorLogicMode)mode).getDescription()});
        }
    }

    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        TYPE mode = this.getMode();
        if (mode == null) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        MekanismRenderer.color((EnumColor)((IReactorLogicMode)mode).getColor());
        ReactorLogicButton.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)(mode == this.tile.getMode() ? 22.0f : 0.0f), (int)this.f_93618_, (int)this.f_93619_, (int)128, (int)44);
        MekanismRenderer.resetColor();
    }

    private TYPE getMode() {
        int i = this.indexSupplier.getAsInt() + this.index;
        return (TYPE)(i >= 0 && i < ((Enum[])this.modeList.get()).length ? ((Enum[])this.modeList.get())[i] : null);
    }

    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        TYPE mode = this.getMode();
        if (mode != null) {
            int typeOffset = 22 * this.index;
            this.gui().renderItem(matrix, ((IReactorLogicMode)mode).getRenderStack(), 20, 35 + typeOffset);
            this.drawString(matrix, (Component)TextComponentUtil.build((Object[])new Object[]{EnumColor.WHITE, mode}), 39, 34 + typeOffset, this.titleTextColor());
            super.renderForeground(matrix, mouseX, mouseY);
        }
    }
}

