/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen;

import biomesoplenty.common.worldgen.AlphaPerlinNoise;
import net.minecraft.world.level.levelgen.RandomSource;

public class AlphaOctavePerlinNoise {
    private AlphaPerlinNoise[] samplers;
    private int octaves;

    public AlphaOctavePerlinNoise(RandomSource random, int octaves) {
        this.octaves = octaves;
        this.samplers = new AlphaPerlinNoise[octaves];
        for (int i = 0; i < octaves; ++i) {
            this.samplers[i] = new AlphaPerlinNoise(random);
        }
    }

    public double sample(double x, double z) {
        double sum = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            sum += this.samplers[i].sample(x * amplitude, z * amplitude) / amplitude;
            amplitude /= 2.0;
        }
        return sum;
    }

    public double sample(double x, double y, double z, double xFreq, double yFreq, double zFreq) {
        double sum = 0.0;
        double amplitude = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            sum += this.samplers[i].sample(x, y, z, xFreq * amplitude, yFreq * amplitude, zFreq * amplitude, amplitude);
            amplitude /= 2.0;
        }
        return sum;
    }
}

