/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.blockentity.misc.VibrationChamberBlockEntity;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.slot.RestrictedInputSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class VibrationChamberMenu
extends AEBaseMenu
implements IProgressProvider {
    public static final MenuType<VibrationChamberMenu> TYPE = MenuTypeBuilder.create(VibrationChamberMenu::new, VibrationChamberBlockEntity.class).build("vibrationchamber");
    private final VibrationChamberBlockEntity vibrationChamber;
    @GuiSync(value=0)
    public int burnSpeed = 0;
    @GuiSync(value=1)
    public int remainingBurnTime = 0;

    public VibrationChamberMenu(int id, Inventory ip, VibrationChamberBlockEntity vibrationChamber) {
        super(TYPE, id, ip, vibrationChamber);
        this.vibrationChamber = vibrationChamber;
        this.addSlot(new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.FUEL, vibrationChamber.getInternalInventory(), 0), SlotSemantics.MACHINE_INPUT);
        this.createPlayerInventorySlots(ip);
    }

    @Override
    public void m_38946_() {
        if (this.isServerSide()) {
            this.remainingBurnTime = this.vibrationChamber.getMaxBurnTime() <= 0.0 ? 0 : (int)(100.0 * this.vibrationChamber.getBurnTime() / this.vibrationChamber.getMaxBurnTime());
            this.burnSpeed = this.remainingBurnTime <= 0 ? 0 : this.vibrationChamber.getBurnSpeed();
        }
        super.m_38946_();
    }

    @Override
    public int getCurrentProgress() {
        return this.burnSpeed;
    }

    public int getRemainingBurnTime() {
        return this.remainingBurnTime;
    }

    @Override
    public int getMaxProgress() {
        return 200;
    }
}

