/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.features.Locatables;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.common.MEStorageMenu;
import appeng.util.ConfigManager;
import java.util.List;
import java.util.OptionalLong;
import java.util.function.DoubleSupplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class WirelessTerminalItem
extends AEBasePoweredItem
implements IMenuItem,
IUpgradeableItem {
    public static final IGridLinkableHandler LINKABLE_HANDLER = new LinkableHandler();
    private static final String TAG_GRID_KEY = "gridKey";

    public WirelessTerminalItem(DoubleSupplier powerCapacity, Item.Properties props) {
        super(powerCapacity, props);
    }

    @Override
    public double getChargeRate(ItemStack stack) {
        return 800.0 + 800.0 * (double)this.getUpgrades(stack).getInstalledUpgrades(AEItems.ENERGY_CARD);
    }

    public boolean openFromInventory(Player player, int inventorySlot) {
        ItemStack is = player.m_150109_().m_8020_(inventorySlot);
        if (this.checkPreconditions(is, player)) {
            return MenuOpener.open(this.getMenuType(), player, MenuLocators.forInventorySlot(inventorySlot));
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack is = player.m_21120_(hand);
        if (this.checkPreconditions(is, player) && MenuOpener.open(this.getMenuType(), player, MenuLocators.forHand(player, hand))) {
            return new InteractionResultHolder(InteractionResult.m_19078_((boolean)level.m_5776_()), (Object)is);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)is);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        super.m_7373_(stack, level, lines, advancedTooltips);
        if (this.getGridKey(stack).isEmpty()) {
            lines.add((Component)Tooltips.of(GuiText.Unlinked, Tooltips.RED, new Object[0]));
        } else {
            lines.add((Component)Tooltips.of(GuiText.Linked, Tooltips.GREEN, new Object[0]));
        }
    }

    public OptionalLong getGridKey(ItemStack item) {
        CompoundTag tag = item.m_41783_();
        if (tag != null && tag.m_128425_(TAG_GRID_KEY, 4)) {
            return OptionalLong.of(tag.m_128454_(TAG_GRID_KEY));
        }
        return OptionalLong.empty();
    }

    public MenuType<?> getMenuType() {
        return MEStorageMenu.WIRELESS_TYPE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @Override
    @Nullable
    public ItemMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, @Nullable BlockPos pos) {
        return new WirelessTerminalMenuHost(player, inventorySlot, stack, (p, subMenu) -> this.openFromInventory((Player)p, inventorySlot));
    }

    protected boolean checkPreconditions(ItemStack item, Player player) {
        if (item.m_41619_() || item.m_41720_() != this) {
            return false;
        }
        Level level = player.m_20193_();
        if (level.m_5776_()) {
            return false;
        }
        OptionalLong key = this.getGridKey(item);
        if (key.isEmpty()) {
            player.m_6352_((Component)PlayerMessages.DeviceNotLinked.text(), Util.f_137441_);
            return false;
        }
        IActionHost securityStation = Locatables.securityStations().get(level, key.getAsLong());
        if (securityStation == null) {
            player.m_6352_((Component)PlayerMessages.StationCanNotBeLocated.text(), Util.f_137441_);
            return false;
        }
        if (!this.hasPower(player, 0.5, item)) {
            player.m_6352_((Component)PlayerMessages.DeviceNotPowered.text(), Util.f_137441_);
            return false;
        }
        return true;
    }

    public boolean usePower(Player player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount, Actionable.MODULATE) >= amount - 0.5;
    }

    public boolean hasPower(Player player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    public IConfigManager getConfigManager(ItemStack target) {
        ConfigManager out = new ConfigManager((manager, settingName) -> manager.writeToNBT(target.m_41784_()));
        out.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        out.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        out.readFromNBT(target.m_41784_().m_6426_());
        return out;
    }

    @Override
    public IUpgradeInventory getUpgrades(ItemStack stack) {
        return UpgradeInventories.forItem(stack, 2, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(ItemStack stack, IUpgradeInventory upgrades) {
        this.setAEMaxPowerMultiplier(stack, 1 + upgrades.getInstalledUpgrades(AEItems.ENERGY_CARD));
    }

    private static class LinkableHandler
    implements IGridLinkableHandler {
        private LinkableHandler() {
        }

        @Override
        public boolean canLink(ItemStack stack) {
            return stack.m_41720_() instanceof WirelessTerminalItem;
        }

        @Override
        public void link(ItemStack itemStack, long securityKey) {
            itemStack.m_41784_().m_128356_(WirelessTerminalItem.TAG_GRID_KEY, securityKey);
        }

        @Override
        public void unlink(ItemStack itemStack) {
            itemStack.m_41749_(WirelessTerminalItem.TAG_GRID_KEY);
        }
    }
}

