/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.config.CondenserOutput;
import appeng.api.implementations.items.IStorageComponent;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.integration.modules.jei.IconDrawable;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

class CondenserCategory
implements IRecipeCategory<CondenserOutput> {
    private static final String TITLE_TRANSLATION_KEY = "block.ae2.Condenser";
    public static final ResourceLocation UID = new ResourceLocation("ae2", "condenser");
    private final IDrawable background;
    private final IDrawableAnimated progress;
    private final IDrawable iconButton;
    private final IDrawable iconTrash;
    private final IDrawable icon;
    private final Map<CondenserOutput, IDrawable> buttonIcons;

    public CondenserCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)AEBlocks.CONDENSER.stack());
        ResourceLocation location = new ResourceLocation("ae2", "textures/guis/condenser.png");
        this.background = guiHelper.createDrawable(location, 50, 25, 94, 48);
        this.iconTrash = new IconDrawable(Icon.BACKGROUND_TRASH, 1, 27);
        this.iconButton = new IconDrawable(Icon.TOOLBAR_BUTTON_BACKGROUND, 78, 26);
        IDrawableStatic progressDrawable = guiHelper.drawableBuilder(location, 178, 25, 6, 18).addPadding(0, 0, 70, 0).build();
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 40, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.buttonIcons = new EnumMap<CondenserOutput, IDrawable>(CondenserOutput.class);
        this.buttonIcons.put(CondenserOutput.MATTER_BALLS, new IconDrawable(Icon.CONDENSER_OUTPUT_MATTER_BALL, 78, 26));
        this.buttonIcons.put(CondenserOutput.SINGULARITY, new IconDrawable(Icon.CONDENSER_OUTPUT_SINGULARITY, 78, 26));
    }

    private ItemStack getOutput(CondenserOutput recipe) {
        return switch (recipe) {
            case CondenserOutput.MATTER_BALLS -> AEItems.MATTER_BALL.stack();
            case CondenserOutput.SINGULARITY -> AEItems.SINGULARITY.stack();
            default -> ItemStack.f_41583_;
        };
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CondenserOutput> getRecipeClass() {
        return CondenserOutput.class;
    }

    public Component getTitle() {
        return new TranslatableComponent(TITLE_TRANSLATION_KEY);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CondenserOutput recipe, IIngredients ingredients) {
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.getOutput(recipe));
    }

    public void draw(CondenserOutput recipe, PoseStack poseStack, double mouseX, double mouseY) {
        this.progress.draw(poseStack);
        this.iconTrash.draw(poseStack);
        this.iconButton.draw(poseStack);
        IDrawable buttonIcon = this.buttonIcons.get((Object)recipe);
        if (buttonIcon != null) {
            buttonIcon.draw(poseStack);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, CondenserOutput output, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 54, 26);
        itemStacks.init(1, true, 50, 0);
        itemStacks.set(1, this.getViableStorageComponents(output));
        itemStacks.set(ingredients);
    }

    private List<ItemStack> getViableStorageComponents(CondenserOutput condenserOutput) {
        ArrayList<ItemStack> viableComponents = new ArrayList<ItemStack>();
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_1K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_4K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_16K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_64K.stack());
        this.addViableComponent(condenserOutput, viableComponents, AEItems.CELL_COMPONENT_256K.stack());
        return viableComponents;
    }

    private void addViableComponent(CondenserOutput condenserOutput, List<ItemStack> viableComponents, ItemStack itemStack) {
        IStorageComponent comp = (IStorageComponent)itemStack.m_41720_();
        int storage = comp.getBytes(itemStack) * 8;
        if (storage >= condenserOutput.requiredPower) {
            viableComponents.add(itemStack);
        }
    }

    public List<Component> getTooltipStrings(CondenserOutput output, double mouseX, double mouseY) {
        if (mouseX >= 28.0 && mouseX < 44.0 && mouseY >= 78.0 && mouseY < 94.0) {
            String key;
            switch (output) {
                case MATTER_BALLS: {
                    key = "gui.tooltips.appliedenergistics2.MatterBalls";
                    break;
                }
                case SINGULARITY: {
                    key = "gui.tooltips.appliedenergistics2.Singularity";
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            return Lists.newArrayList((Object[])new Component[]{new TranslatableComponent(key)});
        }
        return Collections.emptyList();
    }
}

