/*
 * Decompiled with CFR 0.152.
 */
package appeng.init;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.capabilities.Capabilities;
import appeng.core.AppEng;
import appeng.helpers.externalstorage.GenericStackFluidStorage;
import appeng.helpers.externalstorage.GenericStackItemStorage;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InitCapabilities {
    private InitCapabilities() {
    }

    public static void init(RegisterCapabilitiesEvent evt) {
        evt.register(IStorageMonitorableAccessor.class);
        evt.register(ICraftingMachine.class);
        evt.register(GenericInternalInventory.class);
    }

    public static void registerGenericInvWrapper(final AttachCapabilitiesEvent<BlockEntity> event) {
        event.addCapability(AppEng.makeId("generic_inv_wrapper"), new ICapabilityProvider(){
            final BlockEntity be;
            {
                this.be = (BlockEntity)event.getObject();
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return this.be.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(GenericStackItemStorage::new).cast();
                }
                if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                    return this.be.getCapability(Capabilities.GENERIC_INTERNAL_INV, side).lazyMap(GenericStackFluidStorage::new).cast();
                }
                return LazyOptional.empty();
            }
        });
    }
}

