/*
 * Decompiled with CFR 0.152.
 */
package appeng.hotkeys;

import appeng.api.features.HotkeyAction;
import appeng.client.Hotkeys;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.hotkeys.InventoryHotkeyAction;
import appeng.items.tools.powered.PortableCellItem;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HotkeyActions {
    public static final HashMap<String, List<HotkeyAction>> REGISTRY = new HashMap();

    public static void init() {
    }

    public static void registerPortableCell(ItemDefinition<PortableCellItem> cell, String id) {
        HotkeyActions.register(new InventoryHotkeyAction(cell.m_5456_(), cell.m_5456_()::openFromInventory), id);
    }

    public static synchronized void register(HotkeyAction hotkeyAction, String id) {
        if (REGISTRY.containsKey(id)) {
            REGISTRY.get(id).add(0, hotkeyAction);
        } else {
            REGISTRY.put(id, new ArrayList<HotkeyAction>(List.of(hotkeyAction)));
            if (Platform.isClient()) {
                Hotkeys.registerHotkey(id);
            }
        }
    }

    static {
        HotkeyActions.register(new InventoryHotkeyAction(AEItems.WIRELESS_TERMINAL.m_5456_(), (player, i) -> AEItems.WIRELESS_TERMINAL.m_5456_().openFromInventory(player, i)), "wireless_terminal");
        HotkeyActions.register(new InventoryHotkeyAction(AEItems.WIRELESS_CRAFTING_TERMINAL.m_5456_(), (player, i) -> AEItems.WIRELESS_CRAFTING_TERMINAL.m_5456_().openFromInventory(player, i)), "wireless_terminal");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL1K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL4K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL16K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL64K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_ITEM_CELL256K, "portable_item_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL1K, "portable_fluid_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL4K, "portable_fluid_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL16K, "portable_fluid_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL64K, "portable_fluid_cell");
        HotkeyActions.registerPortableCell(AEItems.PORTABLE_FLUID_CELL256K, "portable_fluid_cell");
    }
}

