/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PartLeftClickPacket;
import appeng.util.InteractionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

@OnlyIn(value=Dist.CLIENT)
public final class BlockAttackHook {
    private BlockAttackHook() {
    }

    public static void install() {
        MinecraftForge.EVENT_BUS.addListener(BlockAttackHook::onBlockAttackedOnClientEvent);
    }

    private static void onBlockAttackedOnClientEvent(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getWorld();
        if (!level.m_5776_()) {
            return;
        }
        InteractionResult result = BlockAttackHook.onBlockAttackedOnClient(event.getPlayer(), level);
        if (result != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    private static InteractionResult onBlockAttackedOnClient(Player player, Level level) {
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return InteractionResult.PASS;
        }
        BlockHitResult hitResult2 = (BlockHitResult)hitResult;
        if (BlockAttackHook.onBlockAttackedOnClient(player, level, hitResult2)) {
            Minecraft.m_91087_().f_91072_.f_105195_ = 5;
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private static boolean onBlockAttackedOnClient(Player player, Level level, BlockHitResult hitResult) {
        boolean alternateUseMode;
        boolean activated;
        BlockPos pos = hitResult.m_82425_();
        Vec3 localPos = hitResult.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IPartHost)) {
            return false;
        }
        IPartHost partHost = (IPartHost)blockEntity;
        SelectedPart p = partHost.selectPartLocal(localPos);
        if (p.part != null && (activated = (alternateUseMode = InteractionUtil.isInAlternateUseMode(player)) ? p.part.onShiftClicked(player, localPos) : p.part.onClicked(player, localPos))) {
            NetworkHandler.instance().sendToServer(new PartLeftClickPacket(hitResult, alternateUseMode));
            return true;
        }
        return false;
    }
}

