/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers.iface;

import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.util.IConfigManager;
import appeng.core.settings.TickRates;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.iface.PatternProviderLogicHost;
import appeng.helpers.iface.PatternProviderReturnInventory;
import appeng.helpers.iface.PatternProviderTarget;
import appeng.me.helpers.MachineSource;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class PatternProviderLogic
implements InternalInventoryHost,
ICraftingProvider {
    public static final int NUMBER_OF_PATTERN_SLOTS = 9;
    private final PatternProviderLogicHost host;
    private final IManagedGridNode mainNode;
    private final IActionSource actionSource;
    private final ConfigManager configManager = new ConfigManager(this::saveChanges);
    private int priority;
    private final AppEngInternalInventory patternInventory = new AppEngInternalInventory(this, 9);
    private final List<IPatternDetails> patterns = new ArrayList<IPatternDetails>();
    private final Set<AEKey> patternInputs = new HashSet<AEKey>();
    private final List<GenericStack> sendList = new ArrayList<GenericStack>();
    private Direction sendDirection;
    private final PatternProviderReturnInventory returnInv;
    private static final Collection<Block> BAD_BLOCKS = new HashSet<Block>(100);

    public PatternProviderLogic(IManagedGridNode mainNode, PatternProviderLogicHost host) {
        this.host = host;
        this.mainNode = mainNode.setFlags(GridFlags.REQUIRE_CHANNEL).addService(IGridTickable.class, new Ticker()).addService(ICraftingProvider.class, this);
        this.actionSource = new MachineSource(mainNode::getNode);
        this.configManager.registerSetting(Settings.BLOCKING_MODE, YesNo.NO);
        this.configManager.registerSetting(Settings.PATTERN_ACCESS_TERMINAL, YesNo.YES);
        this.returnInv = new PatternProviderReturnInventory(() -> this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node)));
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
        this.host.saveChanges();
        ICraftingProvider.requestUpdate(this.mainNode);
    }

    public void writeToNBT(CompoundTag tag) {
        this.configManager.writeToNBT(tag);
        this.patternInventory.writeToNBT(tag, "patterns");
        tag.m_128405_("priority", this.priority);
        ListTag sendListTag = new ListTag();
        for (GenericStack toSend : this.sendList) {
            sendListTag.add((Object)GenericStack.writeTag(toSend));
        }
        tag.m_128365_("sendList", (Tag)sendListTag);
        if (this.sendDirection != null) {
            tag.m_128344_("sendDirection", (byte)this.sendDirection.m_122411_());
        }
        tag.m_128365_("returnInv", (Tag)this.returnInv.writeToTag());
    }

    public void readFromNBT(CompoundTag tag) {
        this.configManager.readFromNBT(tag);
        this.patternInventory.readFromNBT(tag, "patterns");
        this.priority = tag.m_128451_("priority");
        ListTag sendListTag = tag.m_128437_("sendList", 10);
        for (int i = 0; i < sendListTag.size(); ++i) {
            GenericStack stack = GenericStack.readTag(sendListTag.m_128728_(i));
            if (stack == null) continue;
            this.addToSendList(stack.what(), stack.amount());
        }
        if (tag.m_128441_("sendDirection")) {
            this.sendDirection = Direction.m_122376_((int)tag.m_128445_("sendDirection"));
        }
        this.returnInv.readFromTag(tag.m_128437_("returnInv", 10));
    }

    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    @Override
    public void saveChanges() {
        this.host.saveChanges();
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        this.saveChanges();
        this.updatePatterns();
    }

    @Override
    public boolean isClientSide() {
        Level level = this.host.getBlockEntity().m_58904_();
        return level == null || level.m_5776_();
    }

    public void updatePatterns() {
        this.patterns.clear();
        this.patternInputs.clear();
        for (ItemStack stack : this.patternInventory) {
            IPatternDetails details = PatternDetailsHelper.decodePattern(stack, this.host.getBlockEntity().m_58904_());
            if (details == null) continue;
            this.patterns.add(details);
            for (IPatternDetails.IInput iinput : details.getInputs()) {
                for (GenericStack inputCandidate : iinput.getPossibleInputs()) {
                    this.patternInputs.add(inputCandidate.what().dropSecondary());
                }
            }
        }
        ICraftingProvider.requestUpdate(this.mainNode);
    }

    @Override
    public List<IPatternDetails> getAvailablePatterns() {
        return this.patterns;
    }

    @Override
    public int getPatternPriority() {
        return this.priority;
    }

    @Override
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!(this.sendList.isEmpty() && this.mainNode.isActive() && this.patterns.contains(patternDetails))) {
            return false;
        }
        BlockEntity be = this.host.getBlockEntity();
        Level level = be.m_58904_();
        for (Direction direction : this.host.getTargets()) {
            PatternProviderLogicHost adjHost;
            BlockPos adjPos = be.m_58899_().m_142300_(direction);
            BlockEntity adjBe = level.m_7702_(adjPos);
            Direction adjBeSide = direction.m_122424_();
            if (adjBe instanceof PatternProviderLogicHost && (adjHost = (PatternProviderLogicHost)adjBe).getLogic().sameGrid(this.mainNode.getGrid())) continue;
            ICraftingMachine craftingMachine = ICraftingMachine.of(adjBe, adjBeSide);
            if (craftingMachine != null && craftingMachine.acceptsPlans()) {
                if (!craftingMachine.pushPattern(patternDetails, inputHolder, adjBeSide)) continue;
                return true;
            }
            PatternProviderTarget adapter = PatternProviderTarget.get(level, adjPos, adjBe, adjBeSide, this.actionSource);
            if (adapter == null || this.isBlocking() && adapter.containsPatternInput(this.patternInputs) || !this.adapterAcceptsAll(adapter, inputHolder)) continue;
            for (KeyCounter inputList : inputHolder) {
                for (Object2LongMap.Entry<AEKey> input : inputList) {
                    long amount;
                    AEKey what = (AEKey)input.getKey();
                    long inserted = adapter.insert(what, amount = input.getLongValue(), Actionable.MODULATE);
                    if (inserted >= amount) continue;
                    this.addToSendList(what, amount - inserted);
                }
            }
            this.sendDirection = direction;
            this.sendStacksOut();
            return true;
        }
        return false;
    }

    private boolean sameGrid(@Nullable IGrid grid) {
        return grid != null && grid == this.mainNode.getGrid();
    }

    public boolean isBlocking() {
        return this.configManager.getSetting(Settings.BLOCKING_MODE) == YesNo.YES;
    }

    private boolean adapterAcceptsAll(PatternProviderTarget target, KeyCounter[] inputHolder) {
        for (KeyCounter inputList : inputHolder) {
            for (Object2LongMap.Entry<AEKey> input : inputList) {
                long inserted = target.insert((AEKey)input.getKey(), input.getLongValue(), Actionable.SIMULATE);
                if (inserted != 0L) continue;
                return false;
            }
        }
        return true;
    }

    private void addToSendList(AEKey what, long amount) {
        if (amount > 0L) {
            this.sendList.add(new GenericStack(what, amount));
            this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    private boolean sendStacksOut() {
        BlockEntity adjBe;
        BlockPos adjPos;
        if (this.sendDirection == null) {
            if (!this.sendList.isEmpty()) {
                throw new IllegalStateException("Invalid pattern provider state, this is a bug.");
            }
            return false;
        }
        BlockEntity be = this.host.getBlockEntity();
        Level level = be.m_58904_();
        PatternProviderTarget adapter = PatternProviderTarget.get(level, adjPos = be.m_58899_().m_142300_(this.sendDirection), adjBe = level.m_7702_(adjPos), this.sendDirection.m_122424_(), this.actionSource);
        if (adapter == null) {
            return false;
        }
        boolean didSomething = false;
        ListIterator<GenericStack> it = this.sendList.listIterator();
        while (it.hasNext()) {
            long amount;
            GenericStack stack = it.next();
            AEKey what = stack.what();
            long inserted = adapter.insert(what, amount = stack.amount(), Actionable.MODULATE);
            if (inserted >= amount) {
                it.remove();
                didSomething = true;
                continue;
            }
            if (inserted <= 0L) continue;
            it.set(new GenericStack(what, amount - inserted));
            didSomething = true;
        }
        if (this.sendList.isEmpty()) {
            this.sendDirection = null;
        }
        return didSomething;
    }

    @Override
    public boolean isBusy() {
        return !this.sendList.isEmpty();
    }

    private boolean hasWorkToDo() {
        return !this.sendList.isEmpty() || !this.returnInv.isEmpty();
    }

    private boolean doWork() {
        return this.returnInv.injectIntoNetwork(this.mainNode.getGrid().getStorageService().getInventory(), this.actionSource) | this.sendStacksOut();
    }

    public InternalInventory getPatternInv() {
        return this.patternInventory;
    }

    public void onMainNodeStateChanged() {
        ICraftingProvider.requestUpdate(this.mainNode);
        if (this.mainNode.hasGridBooted()) {
            this.mainNode.ifPresent((grid, node) -> grid.getTickManager().alertDevice((IGridNode)node));
        }
    }

    public void addDrops(List<ItemStack> drops) {
        for (ItemStack itemStack : this.patternInventory) {
            drops.add(itemStack);
        }
        for (GenericStack genericStack : this.sendList) {
            genericStack.what().addDrops(genericStack.amount(), drops, this.host.getBlockEntity().m_58904_(), this.host.getBlockEntity().m_58899_());
        }
        this.returnInv.addDrops(drops, this.host.getBlockEntity().m_58904_(), this.host.getBlockEntity().m_58899_());
    }

    public PatternProviderReturnInventory getReturnInv() {
        return this.returnInv;
    }

    public Component getTermName() {
        BlockEntity host = this.host.getBlockEntity();
        Level hostWorld = host.m_58904_();
        if (((ICustomNameObject)((Object)this.host)).hasCustomInventoryName()) {
            return ((ICustomNameObject)((Object)this.host)).getCustomInventoryName();
        }
        for (Direction direction : this.host.getTargets()) {
            Optional<Component> displayName;
            PatternProviderLogicHost interfaceHost;
            BlockPos targ = host.m_58899_().m_142300_(direction);
            BlockEntity directedBlockEntity = hostWorld.m_7702_(targ);
            if (directedBlockEntity == null || directedBlockEntity instanceof PatternProviderLogicHost && (interfaceHost = (PatternProviderLogicHost)directedBlockEntity).getLogic().sameGrid(this.mainNode.getGrid())) continue;
            ICraftingMachine craftingMachine = ICraftingMachine.of(directedBlockEntity, direction.m_122424_());
            if (craftingMachine != null && (displayName = craftingMachine.getDisplayName()).isPresent()) {
                return displayName.get();
            }
            ItemTransfer adaptor = InternalInventory.wrapExternal(directedBlockEntity, direction.m_122424_());
            if (adaptor == null || !adaptor.mayAllowTransfer()) continue;
            BlockState directedBlockState = hostWorld.m_8055_(targ);
            Block directedBlock = directedBlockState.m_60734_();
            ItemStack what = new ItemStack((ItemLike)directedBlock, 1);
            try {
                ItemStack g;
                Vec3 from = new Vec3((double)host.m_58899_().m_123341_() + 0.5, (double)host.m_58899_().m_123342_() + 0.5, (double)host.m_58899_().m_123343_() + 0.5);
                from = from.m_82520_((double)direction.m_122429_() * 0.501, (double)direction.m_122430_() * 0.501, (double)direction.m_122431_() * 0.501);
                Vec3 to = from.m_82520_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_());
                HitResult hit = null;
                if (hit != null && !BAD_BLOCKS.contains(directedBlock) && hit.m_82425_().equals((Object)directedBlockEntity.m_58899_()) && !(g = directedBlock.getCloneItemStack(directedBlockState, hit, (BlockGetter)hostWorld, directedBlockEntity.m_58899_(), null)).m_41619_()) {
                    what = g;
                }
            }
            catch (Throwable t) {
                BAD_BLOCKS.add(directedBlock);
            }
            if (what.m_41720_() != Items.f_41852_) {
                return new TranslatableComponent(what.m_41778_());
            }
            Item item = Item.m_41439_((Block)directedBlock);
            if (item != Items.f_41852_) continue;
            return new TranslatableComponent(directedBlock.m_7705_());
        }
        return new TextComponent("Nothing");
    }

    public long getSortValue() {
        BlockEntity te = this.host.getBlockEntity();
        return te.m_58899_().m_123343_() << 24 ^ te.m_58899_().m_123341_() << 8 ^ te.m_58899_().m_123342_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        return this.returnInv.getCapability(capability);
    }

    @Nullable
    public IGrid getGrid() {
        return this.mainNode.getGrid();
    }

    private class Ticker
    implements IGridTickable {
        private Ticker() {
        }

        @Override
        public TickingRequest getTickingRequest(IGridNode node) {
            return new TickingRequest(TickRates.Interface, !PatternProviderLogic.this.hasWorkToDo(), true);
        }

        @Override
        public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
            if (!PatternProviderLogic.this.mainNode.isActive()) {
                return TickRateModulation.SLEEP;
            }
            boolean couldDoWork = PatternProviderLogic.this.doWork();
            return PatternProviderLogic.this.hasWorkToDo() ? (couldDoWork ? TickRateModulation.URGENT : TickRateModulation.SLOWER) : TickRateModulation.SLEEP;
        }
    }
}

