/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.inventories.InternalInventory;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemGenBlockEntity
extends AEBaseBlockEntity
implements InternalInventoryHost {
    private static final Queue<ItemStack> SHARED_POSSIBLE_ITEMS = new ArrayDeque<ItemStack>();
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 16, 64);
    private Item filter = Items.f_41852_;
    private final Queue<ItemStack> possibleItems = new ArrayDeque<ItemStack>();

    public ItemGenBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        if (SHARED_POSSIBLE_ITEMS.isEmpty()) {
            ItemGenBlockEntity.initGlobalPossibleItems();
        }
        this.refillInv();
    }

    private static synchronized void initGlobalPossibleItems() {
        if (SHARED_POSSIBLE_ITEMS.isEmpty()) {
            for (Item item : ForgeRegistries.ITEMS) {
                ItemGenBlockEntity.addPossibleItem(item, SHARED_POSSIBLE_ITEMS);
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128359_("filter", this.filter.getRegistryName().toString());
    }

    @Override
    public void loadTag(CompoundTag data) {
        if (data.m_128441_("filter")) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data.m_128461_("filter")));
            this.setItem(item);
        }
        super.loadTag(data);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability) {
            return LazyOptional.of(this.inv::toItemHandler);
        }
        return super.getCapability(capability, facing);
    }

    public void setItem(Item item) {
        this.filter = item;
        this.possibleItems.clear();
        ItemGenBlockEntity.addPossibleItem(this.filter, this.possibleItems);
        this.refillInv();
    }

    private Queue<ItemStack> getPossibleItems() {
        return this.filter != Items.f_41852_ ? this.possibleItems : SHARED_POSSIBLE_ITEMS;
    }

    private static void addPossibleItem(Item item, Queue<ItemStack> queue) {
        if (item == null || item == Items.f_41852_) {
            return;
        }
        if (item.m_41465_()) {
            ItemStack sampleStack = new ItemStack((ItemLike)item);
            int maxDamage = sampleStack.m_41776_();
            for (int dmg = 0; dmg < maxDamage; ++dmg) {
                ItemStack is = sampleStack.m_41777_();
                is.m_41721_(dmg);
                queue.add(is);
            }
        } else if (item.m_41471_() != null) {
            NonNullList list = NonNullList.m_122779_();
            item.m_6787_(item.m_41471_(), list);
            queue.addAll((Collection<ItemStack>)list);
        }
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv.getStackInSlot(slot).m_41619_()) {
            this.refillSlot(slot);
        }
    }

    private void refillInv() {
        for (int slot = 0; slot < this.inv.size(); ++slot) {
            this.refillSlot(slot);
        }
    }

    private void refillSlot(int slot) {
        ItemStack stack = this.getPossibleItems().poll();
        if (stack != null) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(stack.m_41741_());
            this.inv.setItemDirect(slot, copy);
            this.getPossibleItems().add(stack);
        }
    }
}

