/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.MatrixVertexTransformer;
import appeng.hooks.CompassManager;
import appeng.hooks.CompassResult;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class SkyCompassBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<Float> ROTATION = new ModelProperty();
    private final BakedModel base;
    private final BakedModel pointer;
    private float fallbackRotation = 0.0f;

    public SkyCompassBakedModel(BakedModel base, BakedModel pointer) {
        this.base = base;
        this.pointer = pointer;
    }

    public BakedModel getPointer() {
        return this.pointer;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        float rotation = 0.0f;
        Float rotationFromData = (Float)extraData.getData(ROTATION);
        rotation = rotationFromData != null ? rotationFromData.floatValue() : this.fallbackRotation;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.base.getQuads(state, side, rand, extraData));
        if (side == null && state == null) {
            Matrix4f matrix = new Matrix4f();
            matrix.m_27624_();
            matrix.m_27646_(new Quaternion(0.0f, rotation, 0.0f, false));
            MatrixVertexTransformer transformer = new MatrixVertexTransformer(matrix);
            for (BakedQuad bakedQuad : this.pointer.getQuads(state, side, rand, extraData)) {
                BakedQuadBuilder builder = new BakedQuadBuilder();
                transformer.setParent((IVertexConsumer)builder);
                transformer.setVertexFormat(builder.getVertexFormat());
                bakedQuad.pipe((IVertexConsumer)transformer);
                BakedQuad q = builder.build();
                quads.add(q);
            }
        }
        return quads;
    }

    public boolean m_7541_() {
        return this.base.m_7541_();
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.base.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.base.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return new ItemOverrides(){

            public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
                if (level != null && entity instanceof LocalPlayer) {
                    Player player = (Player)entity;
                    float offRads = (float)((double)(player.m_146908_() / 180.0f * (float)Math.PI) + Math.PI);
                    SkyCompassBakedModel.this.fallbackRotation = offRads + SkyCompassBakedModel.getAnimatedRotation(player.m_142538_(), true);
                } else {
                    SkyCompassBakedModel.this.fallbackRotation = SkyCompassBakedModel.getAnimatedRotation(null, false);
                }
                return originalModel;
            }
        };
    }

    public static float getAnimatedRotation(@Nullable BlockPos pos, boolean prefetch) {
        if (pos != null) {
            CompassResult cr = CompassManager.INSTANCE.getCompassDirection(0L, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            if (prefetch) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        CompassManager.INSTANCE.getCompassDirection(0L, pos.m_123341_() + i - 1, pos.m_123342_(), pos.m_123343_() + j - 1);
                    }
                }
            }
            if (cr.isValidResult()) {
                if (cr.isSpin()) {
                    long timeMillis = System.currentTimeMillis();
                    return (float)(timeMillis %= 500L) / 500.0f * (float)Math.PI * 2.0f;
                }
                return (float)cr.getRad();
            }
        }
        long timeMillis = System.currentTimeMillis();
        return (float)(timeMillis %= 3000L) / 3000.0f * (float)Math.PI * 2.0f;
    }
}

