/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.RenderHelper;
import appeng.decorative.solid.GlassState;
import appeng.decorative.solid.QuartzGlassBlock;
import com.google.common.base.Strings;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

class GlassBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<GlassState> GLASS_STATE = new ModelProperty();
    private static final byte[][][] OFFSETS = GlassBakedModel.generateOffsets();
    static final Material TEXTURE_A = new Material(TextureAtlas.f_118259_, new ResourceLocation("ae2:block/glass/quartz_glass_a"));
    static final Material TEXTURE_B = new Material(TextureAtlas.f_118259_, new ResourceLocation("ae2:block/glass/quartz_glass_b"));
    static final Material TEXTURE_C = new Material(TextureAtlas.f_118259_, new ResourceLocation("ae2:block/glass/quartz_glass_c"));
    static final Material TEXTURE_D = new Material(TextureAtlas.f_118259_, new ResourceLocation("ae2:block/glass/quartz_glass_d"));
    static final Material[] TEXTURES_FRAME = GlassBakedModel.generateTexturesFrame();
    private final TextureAtlasSprite[] glassTextures;
    private final TextureAtlasSprite[] frameTextures;

    private static Material[] generateTexturesFrame() {
        return (Material[])IntStream.range(1, 16).mapToObj(Integer::toBinaryString).map(s -> Strings.padStart((String)s, (int)4, (char)'0')).map(s -> new ResourceLocation("ae2:block/glass/quartz_glass_frame" + s)).map(rl -> new Material(TextureAtlas.f_118259_, rl)).toArray(Material[]::new);
    }

    public GlassBakedModel(Function<Material, TextureAtlasSprite> bakedTextureGetter) {
        this.glassTextures = new TextureAtlasSprite[]{bakedTextureGetter.apply(TEXTURE_A), bakedTextureGetter.apply(TEXTURE_B), bakedTextureGetter.apply(TEXTURE_C), bakedTextureGetter.apply(TEXTURE_D)};
        this.frameTextures = new TextureAtlasSprite[16];
        for (int i = 0; i < TEXTURES_FRAME.length; ++i) {
            this.frameTextures[1 + i] = bakedTextureGetter.apply(TEXTURES_FRAME[i]);
        }
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        if (side == null) {
            return Collections.emptyList();
        }
        GlassState glassState = (GlassState)extraData.getData(GLASS_STATE);
        if (glassState == null) {
            return Collections.emptyList();
        }
        int cx = Math.abs(glassState.getX() % 10);
        int cy = Math.abs(glassState.getY() % 10);
        int cz = Math.abs(glassState.getZ() % 10);
        int u = OFFSETS[cx][cy][cz] % 4;
        int v = OFFSETS[9 - cx][9 - cy][9 - cz] % 4;
        int texIdx = Math.abs((OFFSETS[cx][cy][cz] + (glassState.getX() + glassState.getY() + glassState.getZ())) % 4);
        if (texIdx < 2) {
            u /= 2;
            v /= 2;
        }
        TextureAtlasSprite glassTexture = this.glassTextures[texIdx];
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(5);
        List<Vec3> corners = RenderHelper.getFaceCorners(side);
        quads.add(this.createQuad(side, corners, glassTexture, u, v));
        int edgeBitmask = GlassBakedModel.makeBitmask(glassState, side);
        TextureAtlasSprite sideSprite = this.frameTextures[edgeBitmask];
        if (sideSprite != null) {
            quads.add(this.createQuad(side, corners, sideSprite, 0.0f, 0.0f));
        }
        return quads;
    }

    public boolean m_7547_() {
        return false;
    }

    private static int makeBitmask(GlassState state, Direction side) {
        return switch (side) {
            case Direction.DOWN -> GlassBakedModel.makeBitmask(state, Direction.SOUTH, Direction.EAST, Direction.NORTH, Direction.WEST);
            case Direction.UP -> GlassBakedModel.makeBitmask(state, Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST);
            case Direction.NORTH -> GlassBakedModel.makeBitmask(state, Direction.UP, Direction.WEST, Direction.DOWN, Direction.EAST);
            case Direction.SOUTH -> GlassBakedModel.makeBitmask(state, Direction.UP, Direction.EAST, Direction.DOWN, Direction.WEST);
            case Direction.WEST -> GlassBakedModel.makeBitmask(state, Direction.UP, Direction.SOUTH, Direction.DOWN, Direction.NORTH);
            case Direction.EAST -> GlassBakedModel.makeBitmask(state, Direction.UP, Direction.NORTH, Direction.DOWN, Direction.SOUTH);
            default -> throw new IllegalArgumentException("Unsupported side!");
        };
    }

    private static int makeBitmask(GlassState state, Direction up, Direction right, Direction down, Direction left) {
        int bitmask = 0;
        if (!state.isFlushWith(up)) {
            bitmask |= 1;
        }
        if (!state.isFlushWith(right)) {
            bitmask |= 2;
        }
        if (!state.isFlushWith(down)) {
            bitmask |= 4;
        }
        if (!state.isFlushWith(left)) {
            bitmask |= 8;
        }
        return bitmask;
    }

    private BakedQuad createQuad(Direction side, List<Vec3> corners, TextureAtlasSprite sprite, float uOffset, float vOffset) {
        return this.createQuad(side, corners.get(0), corners.get(1), corners.get(2), corners.get(3), sprite, uOffset, vOffset);
    }

    private BakedQuad createQuad(Direction side, Vec3 c1, Vec3 c2, Vec3 c3, Vec3 c4, TextureAtlasSprite sprite, float uOffset, float vOffset) {
        Vec3 normal = new Vec3((double)side.m_122436_().m_123341_(), (double)side.m_122436_().m_123342_(), (double)side.m_122436_().m_123343_());
        float u1 = Mth.m_14036_((float)(0.0f - uOffset), (float)0.0f, (float)16.0f);
        float u2 = Mth.m_14036_((float)(16.0f - uOffset), (float)0.0f, (float)16.0f);
        float v1 = Mth.m_14036_((float)(0.0f - vOffset), (float)0.0f, (float)16.0f);
        float v2 = Mth.m_14036_((float)(16.0f - vOffset), (float)0.0f, (float)16.0f);
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(side);
        this.putVertex(builder, normal, c1.f_82479_, c1.f_82480_, c1.f_82481_, sprite, u1, v1);
        this.putVertex(builder, normal, c2.f_82479_, c2.f_82480_, c2.f_82481_, sprite, u1, v2);
        this.putVertex(builder, normal, c3.f_82479_, c3.f_82480_, c3.f_82481_, sprite, u2, v2);
        this.putVertex(builder, normal, c4.f_82479_, c4.f_82480_, c4.f_82481_, sprite, u2, v1);
        return builder.build();
    }

    private void putVertex(BakedQuadBuilder builder, Vec3 normal, double x, double y, double z, TextureAtlasSprite sprite, float u, float v) {
        VertexFormat vertexFormat = builder.getVertexFormat();
        block6: for (int e = 0; e < vertexFormat.m_86023_().size(); ++e) {
            VertexFormatElement el = (VertexFormatElement)vertexFormat.m_86023_().get(e);
            switch (el.m_86048_()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_, 0.0f});
                    continue block6;
                }
                case UV: {
                    if (el.m_86049_() == 0) {
                        u = sprite.m_118367_((double)u);
                        v = sprite.m_118393_((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.frameTextures[this.frameTextures.length - 1];
    }

    private static byte[][][] generateOffsets() {
        Random r = new Random(924L);
        byte[][][] offset = new byte[10][10][10];
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                r.nextBytes(offset[x][y]);
            }
        }
        return offset;
    }

    public IModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, IModelData modelData) {
        EnumSet<Direction> flushWith = EnumSet.noneOf(Direction.class);
        for (Direction facing : Direction.values()) {
            if (!GlassBakedModel.isGlassBlock((BlockGetter)level, pos, facing)) continue;
            flushWith.add(facing);
        }
        GlassState glassState = new GlassState(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), flushWith);
        return new ModelDataMap.Builder().withInitial(GLASS_STATE, (Object)glassState).build();
    }

    private static boolean isGlassBlock(BlockGetter level, BlockPos pos, Direction facing) {
        return level.m_8055_(pos.m_142300_(facing)).m_60734_() instanceof QuartzGlassBlock;
    }
}

