/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.interfaceterminal;

import appeng.api.config.Settings;
import appeng.api.config.ShowPatternProviders;
import appeng.api.config.TerminalStyle;
import appeng.api.stacks.AEItemKey;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.interfaceterminal.InterfaceRecord;
import appeng.client.gui.me.interfaceterminal.InterfaceSlot;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.AEConfig;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.implementations.InterfaceTerminalMenu;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class InterfaceTerminalScreen<C extends InterfaceTerminalMenu>
extends AEBaseScreen<C> {
    private static final int GUI_WIDTH = 195;
    private static final int GUI_PADDING_X = 8;
    private static final int GUI_PADDING_Y = 6;
    private static final int GUI_HEADER_HEIGHT = 17;
    private static final int GUI_FOOTER_HEIGHT = 97;
    private static final int INTERFACE_NAME_MARGIN_X = 2;
    private static final int TEXT_MAX_WIDTH = 155;
    private static final int ROW_HEIGHT = 18;
    private static final int DEFAULT_ROW_COUNT = 6;
    private static final int MIN_ROW_COUNT = 3;
    private static final int SLOT_SIZE = 18;
    private static final Rect2i HEADER_BBOX = new Rect2i(0, 0, 195, 17);
    private static final Rect2i ROW_TEXT_TOP_BBOX = new Rect2i(0, 17, 195, 18);
    private static final Rect2i ROW_TEXT_MIDDLE_BBOX = new Rect2i(0, 53, 195, 18);
    private static final Rect2i ROW_TEXT_BOTTOM_BBOX = new Rect2i(0, 89, 195, 18);
    private static final Rect2i ROW_INVENTORY_TOP_BBOX = new Rect2i(0, 35, 195, 18);
    private static final Rect2i ROW_INVENTORY_MIDDLE_BBOX = new Rect2i(0, 71, 195, 18);
    private static final Rect2i ROW_INVENTORY_BOTTOM_BBOX = new Rect2i(0, 107, 195, 18);
    private static final Rect2i FOOTER_BBOX = new Rect2i(0, 125, 195, 97);
    private final HashMap<Long, InterfaceRecord> byId = new HashMap();
    private final HashMultimap<String, InterfaceRecord> byName = HashMultimap.create();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final Scrollbar scrollbar = this.widgets.addScrollBar("scrollbar");
    private final AETextField searchField;
    private boolean refreshList = false;
    private int numLines = 0;
    private final ServerSettingToggleButton showPatternProviders;

    public InterfaceTerminalScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.f_97726_ = 195;
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        this.addToLeftToolbar(new SettingToggleButton<TerminalStyle>(Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
        this.showPatternProviders = new ServerSettingToggleButton<ShowPatternProviders>(Settings.TERMINAL_SHOW_PATTERN_PROVIDERS, ShowPatternProviders.VISIBLE);
        this.addToLeftToolbar(this.showPatternProviders);
        this.searchField = this.widgets.addTextField("search");
        this.searchField.m_94151_(str -> this.refreshList());
    }

    @Override
    public void m_7856_() {
        TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
        int maxLines = terminalStyle == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
        this.numLines = (this.f_96544_ - 17 - 97) / 18;
        this.numLines = Mth.m_14045_((int)this.numLines, (int)3, (int)maxLines);
        this.f_97727_ = 114 + this.numLines * 18;
        super.m_7856_();
        this.m_94718_((GuiEventListener)this.searchField);
        this.resetScrollbar();
    }

    @Override
    public void drawFG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((InterfaceTerminalMenu)this.f_97732_).f_38839_.removeIf(slot -> slot instanceof InterfaceSlot);
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < this.numLines; ++i) {
            if (scrollLevel + i >= this.lines.size()) continue;
            Object lineObj = this.lines.get(scrollLevel + i);
            if (lineObj instanceof InterfaceRecord) {
                InterfaceRecord inv = (InterfaceRecord)lineObj;
                for (int z = 0; z < inv.getInventory().size(); ++z) {
                    ((InterfaceTerminalMenu)this.f_97732_).f_38839_.add((Object)new InterfaceSlot(inv, z, z * 18 + 8, (i + 1) * 18));
                }
                continue;
            }
            if (!(lineObj instanceof String)) continue;
            Object name = (String)lineObj;
            int rows = this.byName.get(name).size();
            if (rows > 1) {
                name = (String)name + " (" + rows + ")";
            }
            name = this.f_96547_.m_92837_((String)name, 155, true);
            this.f_96547_.m_92883_(poseStack, (String)name, 10.0f, (float)(23 + i * 18), textColor);
        }
    }

    @Override
    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.m_5953_(xCoord, yCoord)) {
            this.searchField.m_94144_("");
            return true;
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    @Override
    protected void m_6597_(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof InterfaceSlot) {
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().m_150110_().f_35937_) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InterfaceSlot machineSlot = (InterfaceSlot)slot;
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.getSlotIndex(), machineSlot.getMachineInv().getServerId());
                NetworkHandler.instance().sendToServer(p);
            }
            return;
        }
        super.m_6597_(slot, slotIdx, mouseButton, clickType);
    }

    @Override
    public void drawBG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture("guis/interfaceterminal.png");
        this.blit(poseStack, offsetX, offsetY, HEADER_BBOX);
        int scrollLevel = this.scrollbar.getCurrentScroll();
        int currentY = offsetY + 17;
        this.blit(poseStack, offsetX, currentY + this.numLines * 18, FOOTER_BBOX);
        for (int i = 0; i < this.numLines; ++i) {
            boolean firstLine = i == 0;
            boolean lastLine = i == this.numLines - 1;
            boolean isInvLine = false;
            if (scrollLevel + i < this.lines.size()) {
                Object lineObj = this.lines.get(scrollLevel + i);
                isInvLine = lineObj instanceof InterfaceRecord;
            }
            Rect2i bbox = this.selectRowBackgroundBox(isInvLine, firstLine, lastLine);
            this.blit(poseStack, offsetX, currentY, bbox);
            currentY += 18;
        }
    }

    private Rect2i selectRowBackgroundBox(boolean isInvLine, boolean firstLine, boolean lastLine) {
        if (isInvLine) {
            if (firstLine) {
                return ROW_INVENTORY_TOP_BBOX;
            }
            if (lastLine) {
                return ROW_INVENTORY_BOTTOM_BBOX;
            }
            return ROW_INVENTORY_MIDDLE_BBOX;
        }
        if (firstLine) {
            return ROW_TEXT_TOP_BBOX;
        }
        if (lastLine) {
            return ROW_TEXT_BOTTOM_BBOX;
        }
        return ROW_TEXT_MIDDLE_BBOX;
    }

    public boolean m_5534_(char character, int key) {
        if (character == ' ' && this.searchField.m_94155_().isEmpty()) {
            return true;
        }
        return super.m_5534_(character, key);
    }

    public boolean m_7933_(int keyCode, int scanCode, int p_keyPressed_3_) {
        return super.m_7933_(keyCode, scanCode, p_keyPressed_3_);
    }

    public void postInventoryUpdate(boolean clearExistingData, long inventoryId, CompoundTag invData) {
        if (clearExistingData) {
            this.byId.clear();
            this.refreshList = true;
        } else {
            MutableComponent un = Component.Serializer.m_130701_((String)invData.m_128461_("un"));
            InterfaceRecord current = this.getById(inventoryId, invData.m_128454_("sortBy"), (Component)un);
            for (int x = 0; x < current.getInventory().size(); ++x) {
                String which = Integer.toString(x);
                if (!invData.m_128441_(which)) continue;
                current.getInventory().setItemDirect(x, ItemStack.m_41712_((CompoundTag)invData.m_128469_(which)));
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    @Override
    public void updateBeforeRender() {
        this.showPatternProviders.set(((InterfaceTerminalMenu)this.f_97732_).getShownProviders());
    }

    private void refreshList() {
        this.byName.clear();
        String searchFilterLowerCase = this.searchField.m_94155_().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (InterfaceRecord entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found) {
                ItemStack itemStack;
                Iterator<ItemStack> iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found || entry.getSearchName().contains(searchFilterLowerCase)) {
                this.byName.put((Object)entry.getDisplayName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.resetScrollbar();
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(this.numLines * 18 - 2);
        this.scrollbar.setRange(0, this.lines.size() - this.numLines, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack.m_41619_()) {
            return false;
        }
        CompoundTag encodedValue = itemStack.m_41783_();
        if (encodedValue == null) {
            return false;
        }
        ListTag outTag = encodedValue.m_128437_("out", 10);
        for (int i = 0; i < outTag.size(); ++i) {
            String displayName;
            ItemStack parsedItemStack = ItemStack.m_41712_((CompoundTag)outTag.m_128728_(i));
            AEItemKey itemKey = AEItemKey.of(parsedItemStack);
            if (itemKey == null || !(displayName = itemKey.getDisplayName().getString().toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
        }
        return cache;
    }

    private void reinitialize() {
        this.m_6702_().removeAll(this.f_169369_);
        this.f_169369_.clear();
        this.m_7856_();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set(next);
        this.reinitialize();
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private InterfaceRecord getById(long id, long sortBy, Component name) {
        InterfaceRecord o = this.byId.get(id);
        if (o == null) {
            o = new InterfaceRecord(id, 9, sortBy, name);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }

    private void blit(PoseStack poseStack, int offsetX, int offsetY, Rect2i srcRect) {
        this.m_93228_(poseStack, offsetX, offsetY, srcRect.m_110085_(), srcRect.m_110086_(), srcRect.m_110090_(), srcRect.m_110091_());
    }
}

