/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.style.PaletteColor;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class AbstractTableRenderer<T> {
    private static final int CELL_WIDTH = 67;
    private static final int CELL_HEIGHT = 22;
    private static final int ROWS = 5;
    private static final int COLS = 3;
    private static final int CELL_BORDER = 1;
    private static final int LINE_SPACING = 1;
    private static final float TEXT_SCALE = 0.5f;
    private static final float INV_TEXT_SCALE = 2.0f;
    protected final AEBaseScreen<?> screen;
    private final Font fontRenderer;
    private final float lineHeight;
    private final int x;
    private final int y;
    private GenericStack hoveredStack;

    public AbstractTableRenderer(AEBaseScreen<?> screen, int x, int y) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.fontRenderer = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(this.fontRenderer);
        this.lineHeight = 9.0f * 0.5f;
    }

    public final void render(PoseStack poseStack, int mouseX, int mouseY, List<T> entries, int scrollOffset) {
        mouseX -= this.screen.getGuiLeft();
        mouseY -= this.screen.getGuiTop();
        int textColor = this.screen.getStyle().getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        List<Component> tooltipLines = null;
        GenericStack hovered = null;
        for (int row = 0; row < 5; ++row) {
            int i;
            for (int col = 0; col < 3 && (i = (row + scrollOffset) * 3 + col) < entries.size(); ++col) {
                T entry = entries.get(i);
                int cellX = this.x + col * 68;
                int cellY = this.y + row * 23;
                int background = this.getEntryBackgroundColor(entry);
                if (background != 0) {
                    GuiComponent.m_93172_((PoseStack)poseStack, (int)cellX, (int)cellY, (int)(cellX + 67), (int)(cellY + 22), (int)background);
                }
                List<Component> lines = this.getEntryDescription(entry);
                float textHeight = (float)lines.size() * this.lineHeight;
                if (lines.size() > 1) {
                    textHeight += (float)((lines.size() - 1) * 1);
                }
                float textY = Math.round((float)cellY + (22.0f - textHeight) / 2.0f);
                int itemX = cellX + 67 - 19;
                poseStack.m_85836_();
                poseStack.m_85841_(0.5f, 0.5f, 1.0f);
                for (Component line : lines) {
                    int w = this.fontRenderer.m_92852_((FormattedText)line);
                    this.fontRenderer.m_92889_(poseStack, line, (float)((int)(((float)(itemX - 2) - (float)w * 0.5f) * 2.0f)), textY * 2.0f, textColor);
                    textY += this.lineHeight + 1.0f;
                }
                poseStack.m_85849_();
                AEKey entryStack = this.getEntryStack(entry);
                int itemY = cellY + 3;
                AEStackRendering.drawInGui(Minecraft.m_91087_(), poseStack, itemX, itemY, this.screen.m_93252_(), entryStack);
                int overlay = this.getEntryOverlayColor(entry);
                if (overlay != 0) {
                    GuiComponent.m_93172_((PoseStack)poseStack, (int)cellX, (int)cellY, (int)(cellX + 67), (int)(cellY + 22), (int)overlay);
                }
                if (mouseX < cellX || mouseX > cellX + 67 || mouseY < cellY || mouseY > cellY + 22) continue;
                tooltipLines = this.getEntryTooltip(entry);
                hovered = new GenericStack(entryStack, 0L);
            }
        }
        this.hoveredStack = hovered;
        if (tooltipLines != null) {
            this.screen.drawTooltipWithHeader(poseStack, mouseX, mouseY, tooltipLines);
        }
    }

    public GenericStack getHoveredStack() {
        return this.hoveredStack;
    }

    public static int getScrollableRows(int size) {
        return (size + 3 - 1) / 3 - 5;
    }

    protected abstract List<Component> getEntryDescription(T var1);

    protected abstract AEKey getEntryStack(T var1);

    protected abstract List<Component> getEntryTooltip(T var1);

    protected int getEntryBackgroundColor(T entry) {
        return 0;
    }

    protected int getEntryOverlayColor(T entry) {
        return 0;
    }
}

