/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.core.AppEng;
import appeng.helpers.AEMultiBlockEntity;
import appeng.hooks.ticking.TickHandler;
import appeng.parts.CableBusContainer;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class CableBusBlockEntity
extends AEBaseBlockEntity
implements AEMultiBlockEntity {
    private CableBusContainer cb = new CableBusContainer(this);
    private int oldLV = -1;

    public CableBusBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.getCableBus().readFromNBT(data);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.getCableBus().writeToNBT(data);
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        boolean ret = this.getCableBus().readFromStream(data);
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.f_58857_.m_5518_().m_142202_(this.f_58858_);
            ret = true;
        }
        this.updateBlockEntitySettings();
        return ret || c;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        this.getCableBus().writeToStream(data);
    }

    protected void updateBlockEntitySettings() {
    }

    public void m_7651_() {
        super.m_7651_();
        this.getCableBus().removeFromWorld();
    }

    public void m_6339_() {
        super.m_6339_();
        TickHandler.instance().addInit(this);
    }

    @Override
    public IGridNode getGridNode(Direction dir) {
        return this.getCableBus().getGridNode(dir);
    }

    @Override
    public AECableType getCableConnectionType(Direction side) {
        return this.getCableBus().getCableConnectionType(side);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return this.getCableBus().getCableConnectionLength(cable);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.getCableBus().removeFromWorld();
    }

    @Override
    public void markForUpdate() {
        if (this.f_58857_ == null) {
            return;
        }
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.f_58857_.m_5518_().m_142202_(this.f_58858_);
        }
        super.markForUpdate();
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        this.getCableBus().addAdditionalDrops(drops);
    }

    @Override
    public void onReady() {
        super.onReady();
        if (this.getCableBus().isEmpty()) {
            if (this.f_58857_.m_7702_(this.f_58858_) == this) {
                this.f_58857_.m_46961_(this.f_58858_, true);
            }
        } else {
            this.getCableBus().addToWorld();
        }
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return this.getCableBus().getFacadeContainer();
    }

    @Override
    @javax.annotation.Nullable
    public IPart getPart(@javax.annotation.Nullable Direction side) {
        return this.cb.getPart(side);
    }

    @Override
    public boolean canAddPart(ItemStack is, Direction side) {
        return this.getCableBus().canAddPart(is, side);
    }

    @Override
    @javax.annotation.Nullable
    public <T extends IPart> T addPart(IPartItem<T> partItem, Direction side, @Nullable Player player) {
        return this.cb.addPart(partItem, side, player);
    }

    @Override
    @Nullable
    public <T extends IPart> T replacePart(IPartItem<T> partItem, @Nullable Direction side, Player owner, InteractionHand hand) {
        return this.cb.replacePart(partItem, side, owner, hand);
    }

    @Override
    public void removePart(@javax.annotation.Nullable Direction side) {
        this.getCableBus().removePart(side);
    }

    @Override
    public DimensionalBlockPos getLocation() {
        return new DimensionalBlockPos(this);
    }

    @Override
    public AEColor getColor() {
        return this.getCableBus().getColor();
    }

    @Override
    public void clearContainer() {
        this.setCableBus(new CableBusContainer(this));
    }

    @Override
    public boolean isBlocked(Direction side) {
        return false;
    }

    @Override
    public SelectedPart selectPartLocal(Vec3 pos) {
        return this.getCableBus().selectPartLocal(pos);
    }

    @Override
    public void markForSave() {
        this.saveChanges();
    }

    @Override
    public void partChanged() {
        this.notifyNeighbors();
    }

    @Override
    public boolean hasRedstone() {
        return this.getCableBus().hasRedstone();
    }

    @Override
    public boolean isEmpty() {
        return this.getCableBus().isEmpty();
    }

    @Override
    public void cleanup() {
        this.m_58904_().m_7471_(this.f_58858_, false);
    }

    @Override
    public void notifyNeighbors() {
        if (this.f_58857_ != null && this.f_58857_.m_46805_(this.f_58858_) && !CableBusContainer.isLoading()) {
            Platform.notifyBlocksOfNeighbors(this.f_58857_, this.f_58858_);
        }
    }

    @Override
    public boolean isInWorld() {
        return this.getCableBus().isInWorld();
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor colour, Player who) {
        return this.getCableBus().recolourBlock(side, colour, who);
    }

    public CableBusContainer getCableBus() {
        return this.cb;
    }

    private void setCableBus(CableBusContainer cb) {
        this.cb = cb;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capabilityClass, @javax.annotation.Nullable Direction partLocation) {
        LazyOptional<T> result;
        IPart part = this.getPart(partLocation);
        LazyOptional<T> lazyOptional = result = part == null ? LazyOptional.empty() : part.getCapability(capabilityClass);
        if (result.isPresent()) {
            return result;
        }
        return super.getCapability(capabilityClass, partLocation);
    }

    @Override
    public IModelData getModelData() {
        Level level = this.m_58904_();
        if (level == null) {
            return EmptyModelData.INSTANCE;
        }
        CableBusRenderState renderState = this.cb.getRenderState();
        renderState.setLevel((BlockAndTintGetter)level);
        renderState.setPos(this.f_58858_);
        return new ModelDataMap.Builder().withInitial(CableBusRenderState.PROPERTY, (Object)renderState).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InteractionResult disassembleWithWrench(Player player, Level level, BlockHitResult hitResult) {
        if (!level.f_46443_) {
            SelectedPart sp;
            ArrayList<ItemStack> is = new ArrayList<ItemStack>();
            AppEng.instance().setPartInteractionPlayer(player);
            try {
                sp = this.cb.selectPartWorld(hitResult.m_82450_());
            }
            finally {
                AppEng.instance().setPartInteractionPlayer(null);
            }
            if (sp.part != null) {
                sp.part.addPartDrop(is, true);
                sp.part.addAdditionalDrops(is, true);
                this.cb.removePart(sp.side);
            }
            BlockPos pos = this.m_58899_();
            if (sp.facade != null) {
                is.add(sp.facade.getItemStack());
                this.cb.getFacadeContainer().removeFacade(this.cb, sp.side);
                Platform.notifyBlocksOfNeighbors(level, pos);
            }
            if (!is.isEmpty()) {
                Platform.spawnDrops(level, pos, is);
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }
}

