/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.helpers.AEMaterials;
import appeng.util.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public abstract class AEBaseBlock
extends Block {
    private boolean isInventory = false;

    protected AEBaseBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public static BlockBehaviour.Properties defaultProps(Material material) {
        return AEBaseBlock.defaultProps(material, material.m_76339_());
    }

    public static BlockBehaviour.Properties defaultProps(Material material, MaterialColor color) {
        return BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)color).m_60913_(2.2f, 11.0f).m_60918_(AEBaseBlock.getDefaultSoundByMaterial(material));
    }

    private static SoundType getDefaultSoundByMaterial(Material mat) {
        if (mat == AEMaterials.GLASS || mat == Material.f_76275_) {
            return SoundType.f_56744_;
        }
        if (mat == Material.f_76278_) {
            return SoundType.f_56742_;
        }
        if (mat == Material.f_76320_) {
            return SoundType.f_56736_;
        }
        return SoundType.f_56743_;
    }

    public boolean m_7278_(BlockState state) {
        return this.isInventory();
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return 0;
    }

    public boolean rotateAroundFaceAxis(LevelAccessor level, BlockPos pos, Direction face) {
        IOrientable rotatable = this.getOrientable((BlockGetter)level, pos);
        if (rotatable != null && rotatable.canBeRotated()) {
            if (this.hasCustomRotation()) {
                this.customRotateBlock(rotatable, face);
                return true;
            }
            Direction forward = rotatable.getForward();
            Direction up = rotatable.getUp();
            for (int rs = 0; rs < 4; ++rs) {
                if (!this.isValidOrientation(level, pos, forward = Platform.rotateAround(forward, face), up = Platform.rotateAround(up, face))) continue;
                rotatable.setOrientation(forward, up);
                return true;
            }
        }
        return false;
    }

    public final Direction mapRotation(IOrientable ori, Direction dir) {
        Direction forward = ori.getForward();
        Direction up = ori.getUp();
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.m_122430_() * up.m_122431_() - forward.m_122431_() * up.m_122430_();
        int west_y = forward.m_122431_() * up.m_122429_() - forward.m_122429_() * up.m_122431_();
        int west_z = forward.m_122429_() * up.m_122430_() - forward.m_122430_() * up.m_122429_();
        Direction west = null;
        for (Direction dx : Direction.values()) {
            if (dx.m_122429_() != west_x || dx.m_122430_() != west_y || dx.m_122431_() != west_z) continue;
            west = dx;
        }
        if (west == null) {
            return dir;
        }
        if (dir == forward) {
            return Direction.SOUTH;
        }
        if (dir == forward.m_122424_()) {
            return Direction.NORTH;
        }
        if (dir == up) {
            return Direction.UP;
        }
        if (dir == up.m_122424_()) {
            return Direction.DOWN;
        }
        if (dir == west) {
            return Direction.WEST;
        }
        if (dir == west.m_122424_()) {
            return Direction.EAST;
        }
        return null;
    }

    public String toString() {
        String regName = this.getRegistryName() != null ? this.getRegistryName().m_135815_() : "unregistered";
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + regName + "]";
    }

    protected boolean hasCustomRotation() {
        return false;
    }

    protected void customRotateBlock(IOrientable rotatable, Direction axis) {
    }

    protected IOrientable getOrientable(BlockGetter level, BlockPos pos) {
        AEBaseBlock aEBaseBlock = this;
        if (aEBaseBlock instanceof IOrientableBlock) {
            IOrientableBlock orientable = (IOrientableBlock)((Object)aEBaseBlock);
            return orientable.getOrientable(level, pos);
        }
        return null;
    }

    protected boolean isValidOrientation(LevelAccessor level, BlockPos pos, Direction forward, Direction up) {
        return true;
    }

    protected boolean isInventory() {
        return this.isInventory;
    }

    protected void setInventory(boolean isInventory) {
        this.isInventory = isInventory;
    }
}

