/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.networking;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IGridVisitor;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AEColor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;

public interface IGridNode {
    @Nullable
    public <T extends IGridNodeService> T getService(Class<T> var1);

    public Object getOwner();

    public void beginVisit(IGridVisitor var1);

    public IGrid getGrid();

    public ServerLevel getLevel();

    public Set<Direction> getConnectedSides();

    public Map<Direction, IGridConnection> getInWorldConnections();

    public List<IGridConnection> getConnections();

    default public boolean isActive() {
        return this.isPowered() && this.hasGridBooted() && this.meetsChannelRequirements();
    }

    public boolean hasGridBooted();

    public boolean isPowered();

    public boolean meetsChannelRequirements();

    public boolean hasFlag(GridFlags var1);

    public int getOwningPlayerId();

    @Nonnegative
    public double getIdlePowerUsage();

    public boolean isExposedOnSide(Direction var1);

    @Nullable
    public AEItemKey getVisualRepresentation();

    public AEColor getGridColor();

    public void fillCrashReportCategory(CrashReportCategory var1);

    public int getMaxChannels();

    public int getUsedChannels();
}

