/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.virtual;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface VirtualEmptyBlockGetter
extends BlockAndTintGetter {
    public static final VirtualEmptyBlockGetter INSTANCE = new StaticLightImpl(0, 15);
    public static final VirtualEmptyBlockGetter FULL_BRIGHT = new StaticLightImpl(15, 15);
    public static final VirtualEmptyBlockGetter FULL_DARK = new StaticLightImpl(0, 0);

    public static boolean is(BlockAndTintGetter blockGetter) {
        return blockGetter instanceof VirtualEmptyBlockGetter;
    }

    default public BlockEntity m_7702_(BlockPos pos) {
        return null;
    }

    default public BlockState m_8055_(BlockPos pos) {
        return Blocks.f_50016_.m_49966_();
    }

    default public FluidState m_6425_(BlockPos pos) {
        return Fluids.f_76191_.m_76145_();
    }

    default public int m_141928_() {
        return 1;
    }

    default public int m_141937_() {
        return 0;
    }

    default public float m_7717_(Direction direction, boolean shaded) {
        return 1.0f;
    }

    default public int m_6171_(BlockPos pos, ColorResolver resolver) {
        Biome plainsBiome = (Biome)Minecraft.m_91087_().m_91403_().m_105152_().m_175515_(Registry.f_122885_).m_123013_(Biomes.f_48202_);
        return resolver.m_130045_(plainsBiome, (double)pos.m_123341_(), (double)pos.m_123343_());
    }

    public static class StaticLightImpl
    implements VirtualEmptyBlockGetter {
        private final LevelLightEngine lightEngine;

        public StaticLightImpl(final int blockLight, final int skyLight) {
            this.lightEngine = new LevelLightEngine(new LightChunkGetter(){

                public BlockGetter m_6196_(int p_63023_, int p_63024_) {
                    return this;
                }

                public BlockGetter m_7653_() {
                    return this;
                }
            }, false, false){
                private final LayerLightEventListener blockListener;
                private final LayerLightEventListener skyListener;
                {
                    super(p_75805_, p_75806_, p_75807_);
                    this.blockListener = StaticLightImpl.createStaticListener(blockLight);
                    this.skyListener = StaticLightImpl.createStaticListener(skyLight);
                }

                public LayerLightEventListener m_75814_(LightLayer layer) {
                    return layer == LightLayer.BLOCK ? this.blockListener : this.skyListener;
                }
            };
        }

        private static LayerLightEventListener createStaticListener(final int light) {
            return new LayerLightEventListener(){

                public void m_142202_(BlockPos pos) {
                }

                public void m_142519_(BlockPos pos, int p_164456_) {
                }

                public boolean m_142182_() {
                    return false;
                }

                public int m_142528_(int p_164449_, boolean p_164450_, boolean p_164451_) {
                    return p_164449_;
                }

                public void m_6191_(SectionPos pos, boolean p_75838_) {
                }

                public void m_141940_(ChunkPos pos, boolean p_164453_) {
                }

                public DataLayer m_8079_(SectionPos pos) {
                    return null;
                }

                public int m_7768_(BlockPos pos) {
                    return light;
                }
            };
        }

        public LevelLightEngine m_5518_() {
            return this.lightEngine;
        }
    }
}

