/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.VertexList;
import com.jozufozu.flywheel.core.vertex.BlockVertex;
import com.jozufozu.flywheel.core.vertex.VertexWriterUnsafe;
import com.jozufozu.flywheel.util.RenderMath;
import java.nio.ByteBuffer;
import org.lwjgl.system.MemoryUtil;

public class BlockWriterUnsafe
extends VertexWriterUnsafe<BlockVertex> {
    public BlockWriterUnsafe(BlockVertex type, ByteBuffer buffer) {
        super(type, buffer);
    }

    @Override
    public void writeVertex(VertexList list, int i) {
        float x = list.getX(i);
        float y = list.getY(i);
        float z = list.getZ(i);
        float xN = list.getNX(i);
        float yN = list.getNY(i);
        float zN = list.getNZ(i);
        float u = list.getU(i);
        float v = list.getV(i);
        byte r = list.getR(i);
        byte g = list.getG(i);
        byte b = list.getB(i);
        byte a = list.getA(i);
        int light = list.getLight(i);
        this.putVertex(x, y, z, u, v, r, g, b, a, light, xN, yN, zN);
    }

    public void putVertex(float x, float y, float z, float u, float v, byte r, byte g, byte b, byte a, int light, float nX, float nY, float nZ) {
        MemoryUtil.memPutFloat((long)this.ptr, (float)x);
        MemoryUtil.memPutFloat((long)(this.ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(this.ptr + 8L), (float)z);
        MemoryUtil.memPutByte((long)(this.ptr + 12L), (byte)r);
        MemoryUtil.memPutByte((long)(this.ptr + 13L), (byte)g);
        MemoryUtil.memPutByte((long)(this.ptr + 14L), (byte)b);
        MemoryUtil.memPutByte((long)(this.ptr + 15L), (byte)a);
        MemoryUtil.memPutFloat((long)(this.ptr + 16L), (float)u);
        MemoryUtil.memPutFloat((long)(this.ptr + 20L), (float)v);
        MemoryUtil.memPutInt((long)(this.ptr + 24L), (int)(light << 8));
        MemoryUtil.memPutByte((long)(this.ptr + 28L), (byte)RenderMath.nb(nX));
        MemoryUtil.memPutByte((long)(this.ptr + 29L), (byte)RenderMath.nb(nY));
        MemoryUtil.memPutByte((long)(this.ptr + 30L), (byte)RenderMath.nb(nZ));
        this.ptr += 32L;
        this.advance();
    }
}

