/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader;

import com.jozufozu.flywheel.core.source.FileResolution;
import com.jozufozu.flywheel.core.source.Resolver;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;

public class ProgramSpec {
    public static final Codec<ProgramSpec> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("vertex").forGetter(ProgramSpec::getSourceLoc), (App)ResourceLocation.f_135803_.fieldOf("fragment").forGetter(ProgramSpec::getFragmentLoc)).apply((Applicative)instance, ProgramSpec::new));
    public ResourceLocation name;
    public final FileResolution vertex;
    public final FileResolution fragment;

    public ProgramSpec(ResourceLocation vertex, ResourceLocation fragment) {
        this.vertex = Resolver.INSTANCE.get(vertex);
        this.fragment = Resolver.INSTANCE.get(fragment);
    }

    public void setName(ResourceLocation name) {
        this.name = name;
        this.vertex.addSpec(name);
        this.fragment.addSpec(name);
    }

    public ResourceLocation getSourceLoc() {
        return this.vertex.getFileLoc();
    }

    public ResourceLocation getFragmentLoc() {
        return this.fragment.getFileLoc();
    }

    public SourceFile getVertexFile() {
        return this.vertex.getFile();
    }

    public SourceFile getFragmentFile() {
        return this.fragment.getFile();
    }

    public String toString() {
        return this.name.toString();
    }
}

