/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferBuilder;
import com.jozufozu.flywheel.core.model.ShadeSeparatingVertexConsumer;
import com.jozufozu.flywheel.core.virtual.VirtualEmptyBlockGetter;
import com.jozufozu.flywheel.core.virtual.VirtualEmptyModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class ModelUtil {
    public static final BlockRenderDispatcher VANILLA_RENDERER = ModelUtil.createVanillaRenderer();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    private static BlockRenderDispatcher createVanillaRenderer() {
        BlockRenderDispatcher defaultDispatcher = Minecraft.m_91087_().m_91289_();
        BlockRenderDispatcher dispatcher = new BlockRenderDispatcher(null, null, null);
        try {
            for (Field field : BlockRenderDispatcher.class.getDeclaredFields()) {
                field.setAccessible(true);
                field.set(dispatcher, field.get(defaultDispatcher));
            }
            ObfuscationReflectionHelper.setPrivateValue(BlockRenderDispatcher.class, (Object)dispatcher, (Object)new ModelBlockRenderer(Minecraft.m_91087_().m_91298_()), (String)"f_110900_");
        }
        catch (Exception e) {
            Flywheel.LOGGER.error("Failed to initialize vanilla BlockRenderDispatcher!", (Throwable)e);
            return defaultDispatcher;
        }
        return dispatcher;
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilder(BakedModel model, BlockState referenceState, PoseStack poseStack) {
        return ModelUtil.getBufferBuilder(VirtualEmptyBlockGetter.INSTANCE, model, referenceState, poseStack);
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilder(BlockAndTintGetter renderWorld, BakedModel model, BlockState referenceState, PoseStack poseStack) {
        ModelBlockRenderer blockRenderer = VANILLA_RENDERER.m_110937_();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        ShadeSeparatingVertexConsumer shadeSeparatingWrapper = objects.shadeSeparatingWrapper;
        ShadeSeparatedBufferBuilder builder = new ShadeSeparatedBufferBuilder(512);
        BufferBuilder unshadedBuilder = objects.unshadedBuilder;
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        unshadedBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        shadeSeparatingWrapper.prepare((VertexConsumer)builder, (VertexConsumer)unshadedBuilder);
        blockRenderer.tesselateBlock(renderWorld, model, referenceState, BlockPos.f_121853_, poseStack, (VertexConsumer)shadeSeparatingWrapper, false, objects.random, 42L, OverlayTexture.f_118083_, (IModelData)VirtualEmptyModelData.INSTANCE);
        shadeSeparatingWrapper.clear();
        unshadedBuilder.m_85721_();
        builder.appendUnshadedVertices(unshadedBuilder);
        builder.m_85721_();
        return builder;
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilderFromTemplate(BlockAndTintGetter renderWorld, RenderType layer, Collection<StructureTemplate.StructureBlockInfo> blocks) {
        return ModelUtil.getBufferBuilderFromTemplate(renderWorld, layer, blocks, new PoseStack());
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilderFromTemplate(BlockAndTintGetter renderWorld, RenderType layer, Collection<StructureTemplate.StructureBlockInfo> blocks, PoseStack poseStack) {
        ModelBlockRenderer modelRenderer = VANILLA_RENDERER.m_110937_();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        Random random = objects.random;
        ShadeSeparatingVertexConsumer shadeSeparatingWrapper = objects.shadeSeparatingWrapper;
        ShadeSeparatedBufferBuilder builder = new ShadeSeparatedBufferBuilder(512);
        BufferBuilder unshadedBuilder = objects.unshadedBuilder;
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        unshadedBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        shadeSeparatingWrapper.prepare((VertexConsumer)builder, (VertexConsumer)unshadedBuilder);
        ForgeHooksClient.setRenderType((RenderType)layer);
        ModelBlockRenderer.m_111000_();
        for (StructureTemplate.StructureBlockInfo info : blocks) {
            BlockState state = info.f_74676_;
            if (state.m_60799_() != RenderShape.MODEL || !ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)layer)) continue;
            BlockPos pos = info.f_74675_;
            poseStack.m_85836_();
            poseStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            modelRenderer.tesselateBlock(renderWorld, VANILLA_RENDERER.m_110910_(state), state, pos, poseStack, (VertexConsumer)shadeSeparatingWrapper, true, random, 42L, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
            poseStack.m_85849_();
        }
        ModelBlockRenderer.m_111077_();
        ForgeHooksClient.setRenderType(null);
        shadeSeparatingWrapper.clear();
        unshadedBuilder.m_85721_();
        builder.appendUnshadedVertices(unshadedBuilder);
        builder.m_85721_();
        return builder;
    }

    public static Supplier<PoseStack> rotateToFace(Direction facing) {
        return () -> {
            PoseStack stack = new PoseStack();
            ((TransformStack)((TransformStack)TransformStack.cast(stack).centre()).rotateToFace(facing.m_122424_())).unCentre();
            return stack;
        };
    }

    private static class ThreadLocalObjects {
        public final Random random = new Random();
        public final ShadeSeparatingVertexConsumer shadeSeparatingWrapper = new ShadeSeparatingVertexConsumer();
        public final BufferBuilder unshadedBuilder = new BufferBuilder(512);

        private ThreadLocalObjects() {
        }
    }
}

