/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.crumbling;

import com.jozufozu.flywheel.backend.RenderLayer;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancedMaterialGroup;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.core.crumbling.AtlasInfo;
import com.jozufozu.flywheel.core.crumbling.CrumblingProgram;
import com.jozufozu.flywheel.core.crumbling.CrumblingRenderer;
import com.jozufozu.flywheel.util.Textures;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.RenderType;

public class CrumblingGroup<P extends CrumblingProgram>
extends InstancedMaterialGroup<P> {
    private int width;
    private int height;

    public CrumblingGroup(InstancingEngine<P> owner, RenderType type) {
        super(owner, type);
    }

    @Override
    public void render(Matrix4f viewProjection, double camX, double camY, double camZ, RenderLayer layer) {
        this.type.m_110185_();
        int renderTex = RenderSystem.m_157203_((int)0);
        this.updateAtlasSize();
        this.type.m_110188_();
        CrumblingRenderer._currentLayer.m_110185_();
        int breakingTex = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157453_((int)0, (int)renderTex);
        RenderSystem.m_157453_((int)4, (int)breakingTex);
        Textures.bindActiveTextures();
        this.renderAll(viewProjection, camX, camY, camZ, layer);
        CrumblingRenderer._currentLayer.m_110188_();
    }

    private void updateAtlasSize() {
        AtlasInfo.SheetSize sheetSize = AtlasInfo.getSheetSize(Textures.getShaderTexture(0));
        if (sheetSize != null) {
            this.width = sheetSize.width();
            this.height = sheetSize.height();
        } else {
            this.height = 256;
            this.width = 256;
        }
    }

    @Override
    public void setup(P p) {
        ((CrumblingProgram)p).setAtlasSize(this.width, this.height);
    }
}

