/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl;

import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.mojang.blaze3d.platform.GlStateManager;

public class GlStateTracker {
    private static final int[] buffers = new int[GlBufferType.values().length];
    private static int vao;
    private static int program;

    public static int getBuffer(GlBufferType type) {
        return buffers[type.ordinal()];
    }

    public static int getVertexArray() {
        return vao;
    }

    public static int getProgram() {
        return program;
    }

    public static void _setBuffer(GlBufferType type, int buffer) {
        GlStateTracker.buffers[type.ordinal()] = buffer;
    }

    public static void _setProgram(int id) {
        program = id;
    }

    public static void _setVertexArray(int id) {
        vao = id;
    }

    public static State getRestoreState() {
        return new State((int[])buffers.clone(), vao, program);
    }

    public record State(int[] buffers, int vao, int program) {
        public void restore() {
            GlBufferType[] values = GlBufferType.values();
            for (int i = 0; i < values.length; ++i) {
                if (this.buffers[i] == buffers[i]) continue;
                GlStateManager.m_84480_((int)values[i].glEnum, (int)this.buffers[i]);
            }
            if (this.vao != vao) {
                GlStateManager.m_157068_((int)this.vao);
            }
            if (this.program != program) {
                GlStateManager.m_84478_((int)this.program);
            }
        }
    }
}

