/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.item.FluidContainerItemAugmentable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PotionInfuserItem
extends FluidContainerItemAugmentable
implements IColorableItem,
DyeableLeatherItem,
IMultiModeItem {
    protected static final int TIME_CONSTANT = 32;
    protected static final int MB_PER_CYCLE = 50;
    protected static final int MB_PER_USE = 250;

    public PotionInfuserItem(Item.Properties builder, int fluidCapacity) {
        this(builder, fluidCapacity, FluidHelper::hasPotionTag);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity, seed) -> this.m_41113_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity, seed) -> (this.getFluidAmount(stack) > 0 ? 0.5f : 0.0f) + (this.getMode(stack) > 0 ? 0.25f : 0.0f));
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalCoreConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "Fluid", "Potion", "Filter"});
    }

    public PotionInfuserItem(Item.Properties builder, int fluidCapacity, Predicate<FluidStack> validator) {
        super(builder, fluidCapacity, validator);
    }

    public PotionInfuserItem setNumSlots(IntSupplier numSlots) {
        this.numSlots = numSlots;
        return this;
    }

    public PotionInfuserItem setAugValidator(BiPredicate<ItemStack, List<ItemStack>> augValidator) {
        this.augValidator = augValidator;
        return this;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.infuser.use").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.infuser.use.sneak").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.infuser.mode." + this.getMode(stack))).m_130940_(ChatFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        FluidStack fluid = this.getFluid(stack);
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)fluid.getTag())) {
            effects.add(new MobEffectInstance(effect.m_19544_(), this.getEffectDuration(effect, stack), this.getEffectAmplifier(effect, stack), effect.m_19571_(), effect.m_19572_()));
        }
        this.potionTooltip(stack, worldIn, tooltip, flagIn, effects);
    }

    public int m_142159_(ItemStack stack) {
        if (this.getFluidAmount(stack) <= 0) {
            return super.m_142159_(stack);
        }
        return this.getFluid(stack).getFluid().getAttributes().getColor(this.getFluid(stack));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.getAmount() >= 250) {
            if (Utils.isServerWorld((Level)entity.f_19853_)) {
                for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)fluid.getTag())) {
                    if (effect.m_19544_().m_8093_()) {
                        effect.m_19544_().m_19461_((Entity)player, (Entity)player, entity, effect.m_19564_(), 0.5);
                        continue;
                    }
                    MobEffectInstance potion = new MobEffectInstance(effect.m_19544_(), this.getEffectDuration(effect, stack) / 2, this.getEffectAmplifier(effect, stack), effect.m_19571_(), effect.m_19572_());
                    entity.m_7292_(potion);
                }
                if (!player.f_36077_.f_35937_) {
                    this.drain(stack, 250, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!Utils.timeCheck((Level)worldIn)) {
            return;
        }
        if (Utils.isClientWorld((Level)worldIn)) {
            return;
        }
        if (!(entityIn instanceof LivingEntity) || Utils.isFakePlayer((Entity)entityIn) || this.getMode(stack) <= 0) {
            return;
        }
        LivingEntity living = (LivingEntity)entityIn;
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.getAmount() >= 50) {
            boolean used = false;
            for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)fluid.getTag())) {
                MobEffectInstance active = (MobEffectInstance)living.m_21221_().get(effect.m_19544_());
                if (active != null && active.m_19557_() >= 40) continue;
                if (effect.m_19544_().m_8093_()) {
                    effect.m_19544_().m_19461_(null, null, (LivingEntity)entityIn, effect.m_19564_(), 0.5);
                } else {
                    MobEffectInstance potion = new MobEffectInstance(effect.m_19544_(), this.getEffectDuration(effect, stack) / 4, this.getEffectAmplifier(effect, stack), effect.m_19571_(), false);
                    living.m_7292_(potion);
                }
                used = true;
            }
            if (entityIn instanceof Player && ((Player)entityIn).f_36077_.f_35937_) {
                return;
            }
            if (used) {
                this.drain(stack, 50, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)subTag, (CompoundTag)augmentData, (String)"PotionAmp");
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)subTag, (CompoundTag)augmentData, (String)"PotionDur");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected boolean useDelegate(ItemStack stack, Player player, InteractionHand hand) {
        FluidStack fluid;
        if (Utils.isFakePlayer((Entity)player) || !player.m_36341_()) {
            return false;
        }
        if (Utils.isServerWorld((Level)player.f_19853_) && (fluid = this.getFluid(stack)) != null && (fluid.getAmount() >= 250 || player.f_36077_.f_35937_)) {
            for (MobEffectInstance effect : PotionUtils.m_43566_((CompoundTag)fluid.getTag())) {
                if (effect.m_19544_().m_8093_()) {
                    effect.m_19544_().m_19461_(null, null, (LivingEntity)player, this.getEffectAmplifier(effect, stack), 1.0);
                    continue;
                }
                MobEffectInstance potion = new MobEffectInstance(effect.m_19544_(), this.getEffectDuration(effect, stack), this.getEffectAmplifier(effect, stack), effect.m_19571_(), false);
                player.m_7292_(potion);
            }
            if (!player.f_36077_.f_35937_) {
                this.drain(stack, 250, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        player.m_6674_(hand);
        stack.m_41754_(5);
        return true;
    }

    public int getColor(ItemStack item, int colorIndex) {
        if (colorIndex == 0) {
            CompoundTag nbt = item.m_41737_("display");
            return nbt != null && nbt.m_128425_("color", 99) ? nbt.m_128451_("color") : 0xFFFFFF;
        }
        if (colorIndex == 2) {
            return this.getFluidAmount(item) > 0 ? this.getFluid(item).getFluid().getAttributes().getColor(this.getFluid(item)) : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.4f, 0.6f + 0.2f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.thermal.infuser.mode." + this.getMode(stack)));
    }
}

